/*
 * Album.java
 * This class create an Album object that extend JComponet.It has lots of features
 * such as create new album, load album, save album, delete album, add page delete
 * page, add, delte edit text, add, delte edit image, etc.
 */

//import statements
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import javax.swing.plaf.basic.BasicFileChooserUI;
import java.util.*;
import java.beans.PropertyVetoException;
import javax.imageio.*;
import java.awt.image.*;
import javax.swing.border.*;

/*
 * Album class
 * This class handles nearly every functional requirement of the Album part. It
 * handles the interface between user and database to make appropriate changes
 * and save and load properly.
 *
 * * Written by : Turki Almadi
 *
 * Version 1.1 30 Nov 2006
 *
 * Revision    Status       Date            By:
 * 1.0         Created      25 Nov 2006    Turki Almadi
 * 1.1         Modified     26 Nov 2006    Zheng Zhang(Simon)
 * 1.2         added        27 Nov 2006    Turki Almadi
 * 1.3         Modified     28 Nov 2006    Zheng Zhang(Simon)
 * 1.3.1       added        27 Nov 2006    Howie Lee, Roger Yang
 * 1.4         Modified     30 Nov 2006    Turki Almdi & Zheng Zhang(Simon)
 */

public class Album extends JComponent
{

	//to add search=============================================================
	SearchPanel pSearch = new SearchPanel();
	//Checking add Image panel
	Frame window = new Frame();
	ImagePanel pAddImage	= new ImagePanel();
	Vector<Integer> SearchResult = new Vector<Integer>();
	JDialog addImagePopUp = new JDialog();
	JDialog dlgResize = new JDialog();
	JDialog dlgRotate = new JDialog();
	JDialog dlgCrop = new JDialog();
	JPanel addImageOp = new JPanel();
	JButton addOk = new JButton("Add Image");
	JButton close = new JButton("Close");
	RFileName fileExt = new RFileName();
	//==========================================================================

	JPanel pCenter	= new JPanel();
	JPanel pAlbum = new JPanel(false);
	JMenuBar albumMenu = new JMenuBar();
	JMenu menu1 = new JMenu("File");
	JMenu menu2 = new JMenu("Edit");
	JMenu menu2text = new JMenu("Text");
	JMenu menu2image = new JMenu("Image");
	JMenu menu2page = new JMenu("Page");

	JMenuItem menu1new = new JMenuItem("New Album");
	JMenuItem menu1load = new JMenuItem("Load Album");
	JMenuItem menu1save = new JMenuItem("Save Album");
	JMenuItem menu1delete = new JMenuItem("Delete Album");
	JMenuItem menu1close = new JMenuItem("Close Album");

	JMenuItem menu2textT = new JMenuItem("add Title");
	JMenuItem menu2textC = new JMenuItem("add Commentary");
	JMenuItem menu2textE = new JMenuItem("edit Text");
	JMenuItem menu2textD = new JMenuItem("delete Text");


	JMenuItem menu2imageC = new JMenuItem("crop Image");
	JMenuItem menu2imageRe = new JMenuItem("resize Image");
	JMenuItem menu2imageRo = new JMenuItem("rotate Image");
	JMenuItem menu2imageD = new JMenuItem("delete Image");

	JMenuItem menu2pageA = new JMenuItem("add Page");
	JMenuItem menu2pageD = new JMenuItem("delete Page");

	//internal window creation
	JInternalFrame albumFrame = new JInternalFrame();
	JPanel pAlbumCenter = new JPanel();
	JComboBox pageNumB = new JComboBox();

	//album list file
	File albumListFileR = new File("Album/albumListR.txt");
	File albumListFileW = new File("Album/tempFile.txt");
	//-----------------------------------------------
	//used when loading with no albums in DB.
	File albumsExist = new File("Album/albumsExist.txt");
	//------------------------------------------------

	//test
	JButton undo = new JButton("Undo image edit");

	//boolean variables for save method.
	boolean saved;
	boolean newAlbum;

	//Album name, album page numbers and current page number.
	String albumName;
	int pageNums;
	int imageNums;
	int textNums;
	int currentPageNum;
	int textSelected;
	int imageSelected;
	JLabel[] textL;
	JLabel[] imageL;
	BufferedImage ImageBuffer = null;
	Image iImage = null;
	Integer imageID;
	//test for undo
	double[] previousSize = new double[2];
	Position[] previousCrop = new Position[2];
	double previousRotation;
	int editType; //1=resize,2=crop,3=rotate.
	int imageEdited;
	boolean systemDelete;

	//Action Handler Declaration.
	ActionHandler f = new ActionHandler();


	public Album()
	{

	   // Create a directory; all ancestor directories must exist
    	boolean success = (new File("Album")).mkdir();
    	if (!success)
    	{
        	// Directory creation failed
        	// or Directory already Exists
    	}

		//delete temp file first..
		if (new File("Album\\temp").exists())
		{
		try{
		deleteDirectory(new File("Album\\temp"));
		}catch(IOException e){}
		}
		boolean success2 = (new File("Album\\temp")).mkdir();
    	if (!success2)
    	{
        	// Directory creation failed
        	// or Directory already Exists

    	}

		try
		{

			if (albumListFileR.exists()==false)
			{
				albumListFileR.createNewFile();
			}

			if (albumListFileW.exists()==false)
			{
				albumListFileW.createNewFile();
			}
		}
		catch (IOException e){
			JOptionPane.showMessageDialog(null,
					"Album File Creation Failed");
		}
		menu1.add(menu1new);
		menu1.add(menu1load);
		menu1.add(menu1save);
		menu1.addSeparator();
		menu1.add(menu1delete);
		menu1.add(menu1close);

		menu2text.add(menu2textT);
		menu2text.add(menu2textC);
		menu2text.add(menu2textE);
		menu2text.add(menu2textD);

		menu2image.add(menu2imageC);
		menu2image.add(menu2imageRe);
		menu2image.add(menu2imageRo);
		menu2image.add(menu2imageD);

		menu2page.add(menu2pageA);
		menu2page.add(menu2pageD);

		menu2.add(menu2page);
		menu2.add(menu2image);
		menu2.add(menu2text);

		albumMenu.add(menu1);
		albumMenu.add(menu2);

		//test
		albumMenu.add(undo);

      pAlbum.setLayout(new BorderLayout());
		pAlbum.add(albumMenu,BorderLayout.NORTH);
		pCenter.setPreferredSize(new Dimension(550,500));
		pAlbum.add(pCenter,BorderLayout.CENTER);
		//to add search ========================================================
		pAlbum.add(pSearch, BorderLayout.EAST);
		//======================================================================


		menu1new.addActionListener(f);
		menu1load.addActionListener(f);
		menu1save.addActionListener(f);
		menu1close.addActionListener(f);
		menu1delete.addActionListener(f);
		menu2textT.addActionListener(f);
		menu2textC.addActionListener(f);
		menu2textE.addActionListener(f);
		menu2textD.addActionListener(f);
		menu2imageC.addActionListener(f);
		menu2imageRe.addActionListener(f);
		menu2imageRo.addActionListener(f);
		menu2imageD.addActionListener(f);
		menu2pageA.addActionListener(f);
		menu2pageD.addActionListener(f);
		//Action listener for page# drop down menu (JComboBox).
		pageNumB.addActionListener(f);
		//search OK
		pSearch.SearchOK.addActionListener(f);
		addOk.addActionListener(f);
		close.addActionListener(f);
		addImageOp.add(addOk);
		addImageOp.add(close);
		addImagePopUp = new JDialog(window, "Add Image", true);
    	addImagePopUp.setLayout(new BorderLayout());
		addImagePopUp.add(pAddImage, BorderLayout.CENTER);
		addImagePopUp.add(addImageOp, BorderLayout.SOUTH);

		//test
		undo.addActionListener(f);

		//disable album related buttons until an album is either created or loaded
		enableButtons(false);
		menu1delete.setEnabled(false);
		menu2textT.setEnabled(false);
		menu2textC.setEnabled(false);
		menu2textE.setEnabled(false);
		menu2textD.setEnabled(false);
		enableImageButtons(false);
		//test
		undo.setEnabled(false);

		//initiate booleans for save method
		saved = false;
		newAlbum = false;

		//internal frame addition
		//pAlbumCenter.setPreferredSize(new Dimension(550,500));
		pAlbumCenter.setLayout(null);
		pAlbumCenter.setOpaque(true);
		//pAlbumCenter.setBackground(Color.BLUE.darker());
		pAlbumCenter.addMouseListener(new java.awt.event.MouseAdapter() {
      public void mouseClicked(java.awt.event.MouseEvent evt) {
      LabelMouseClicked(evt);}});

	   albumFrame.add(pageNumB,BorderLayout.NORTH);
		albumFrame.add(pAlbumCenter,BorderLayout.CENTER);
		albumFrame.setDefaultCloseOperation(JFrame.HIDE_ON_CLOSE);
	   albumFrame.setPreferredSize(new Dimension(550,500));
		pCenter.add(albumFrame,BorderLayout.CENTER);


	}//a constructor
//----------------------------------------
    /*
     * AlbumPanel Class
     * This function call other function to perform the action and enables the
     * proper button for proper time
     */
    public JComponent AlbumPanel()
    {
        return pAlbum;
    }

   //Action Listeners
	public class ActionHandler implements ActionListener
	{
		public void actionPerformed(ActionEvent f)
		{
			if (f.getSource() == menu1new)
			 {
			   menu1new.setEnabled(false);
			   menu1load.setEnabled(false);
           	   createNewAlbum();
			 }

			else if (f.getSource() == menu1load)
			 {
			   menu1new.setEnabled(false);
			   menu1load.setEnabled(false);
			   loadAlbum();
			 }

			else if (f.getSource() == menu1save)
			 {
			   saveAlbum();
			   menu1delete.setEnabled(true);
			 }

			else if (f.getSource() == menu1close)
			 {
			   closeAlbum();

			 }

			else if (f.getSource() == menu1delete)
			 {
			   deleteAlbum();

			 }
			else if (f.getSource() == menu2textT)
			 {
			   addText(true);
			 }

			else if (f.getSource() == menu2textC)
			 {
			   addText(false);
			 }

			else if (f.getSource() == menu2textE)
			 {
			   editText();
			 }

			else if (f.getSource() == menu2textD)
			 {
			   deleteText();
			 }
	        else if (f.getSource() == menu2imageC)
			 {
			   if(imageSelected == -1)
			   {
			   	JOptionPane.showMessageDialog(null,"No image was selected!");
			   }
			   else
			   {
			   	cropImage();
			   }
			 }

			else if (f.getSource() == menu2imageRe)
			 {
			   if(imageSelected == -1)
			   {
			   	JOptionPane.showMessageDialog(null,"No image was selected!");
			   }
			   else
			   {
			   	resizeImage();
			   }
			 }

			else if (f.getSource() == menu2imageRo)
			 {
			   if(imageSelected == -1)
			   {
			   	JOptionPane.showMessageDialog(null,"No image was selected!");
			   }
			   else
			   {
			   	rotateImage();
			   }
			 }
			else if (f.getSource() == menu2imageD)
			 {
			   deleteImage();
			 }

			else if (f.getSource() == menu2pageA)
			 {
			   addPage();
			 }

			else if (f.getSource() == menu2pageD)
			 {
			   deletePage();
			 }

			else if (f.getSource() == pageNumB)
			 {
			   //get the page# from the ComboBox when the user changes selection.
				currentPageNum = (Integer) pageNumB.getSelectedItem();
				//update frame (by loading content of new selected page#).
				try{updateAlbumFrame();} catch(IOException e){}
				//test
	         undo.setEnabled(false);
			 }

			//test
			else if (f.getSource() == undo)
			 {
			   undo();
			 }

			else if (f.getSource() == pSearch.SearchOK)
			 {
				SearchResult = pSearch.Search();
				/*Search Debug Messages
				System.out.println("=============new Search=============");
				for (int i= 0; i<SearchResult.size(); i++)
				{
					System.out.println(SearchResult.get(i));
				}*/
				imageID = -1;
				pAddImage.showImage(SearchResult);
				pAddImage.updateUI();
				addImagePopUp.setPreferredSize(new Dimension(550,550));
	         addImagePopUp.pack();
	         addImagePopUp.setLocationRelativeTo(null);
	         addImagePopUp.setVisible(true);
			 }

			else if (f.getSource() == addOk)
			 {
			   imageID = pAddImage.selectPicture;
			   	//debug message
				//System.out.println(imageID);
				//System.out.println(albumName);
				//System.out.println(currentPageNum);
				if (currentPageNum < 1)
				{
		  			JOptionPane.showMessageDialog(null,"No album is opened, or album has no pages!");
		  			addImagePopUp.dispose();
				}
				else
				{
					addImage();
				}
			 }

			else if (f.getSource()== close)
			{
				addImagePopUp.dispose();
			}
		}
	}//end Action Listeners



	/*
	 * Class createNewAlbum.
	 * New Album is created if user did not cancel and no duplication of creation
	 * new album is stored in temp file, if saved then information passed. if not,
	 * any change is lost.
	 *
	 * precondition:system is at the album part, no album loaded or no other new
	 *              album is not closed yet.
	 *
	 * postcondition: the system is creating a new album with the user input name
	 *                and read to be modified or saved, or close.d
	 */
	//when New Album is selected
	public void createNewAlbum()
	{
	 //+++++++++++++++++++++++++++++++++++++++++++++++++++++//
	 //+                                                   +//
	 //+ First check if no album with the same name exists +//
	 //+ Then, create an empty folde in Album/temp         +//
	 //+ It's moved to Album and album name is stored in   +//
	 //+ the album list when it's saved.                   +//
	 //+                                                   +//
	 //+++++++++++++++++++++++++++++++++++++++++++++++++++++//

	 // Variables declarations and Error Handling
	 String newName;
	 newName = JOptionPane.showInputDialog("Please type in the album name:");

	 if (newName != null)
	 {
	  if (newName.hashCode() == 0)
	  {
	    JOptionPane.showMessageDialog(null,"No name was entered, please try again or cancel");
		 createNewAlbum();
	  }

	  String name = new String();
      boolean nameExists = false;

	  try
	   {
		   BufferedReader in = new BufferedReader(new FileReader(albumListFileR));

		   //firs check if album name already exists (ignore case)
			while ((name = in.readLine()) != null)
			{
			  if (name.equalsIgnoreCase(newName))
			   {
			     JOptionPane.showMessageDialog(null,"Name already exists, please choose another!");
				  nameExists = true;
				  createNewAlbum();
			   }

			  name = new String();
	       }
			//end while
			in.close();


			//create a new directory and save it in temp.
		    if (!nameExists && newName.hashCode() != 0)
			 {
			  albumName = newName;
			  pageNums = 0;

			  // DB
			  (new File("Album\\temp")).mkdir();
			  boolean success = (new File("Album\\temp\\"+newName)).mkdir();
    	      if (!success)
    	      {
        	   // Directory creation failed
        	   // or Directory already Exists
    	      }

    	     //End DB

			  JOptionPane.showMessageDialog(null,"Album created!");

			  //enable buttons
			  enableButtons(true);

			  saved = false;//since it's just been created.
			  newAlbum = true; //new album.

		    }

	    }
	   catch ( IOException e )
       {
         //System.out.println(e);
	    }

	  //update GUI (load content)
	  pageNumB.setEnabled(false);
	  pageNumB.removeActionListener(f);//remove Action listner so that no errors occur.
	  pageNumB.removeAllItems();
	  try{updateAlbumFrame();}catch(IOException e){}
	  pageNumB.addActionListener(f);//add it again.

	  //test
	  undo.setEnabled(false);

	 }else {
        // User clicked NO for input albumName.
        menu1new.setEnabled(true);
		menu1load.setEnabled(true);
     }
	}//end createNewAlbum



	/*
	 * Class loadAlbum.
	 * AN Album is load if user did not cancel and user choosen a exist album to
	 * load. at least one album need to be saved before.loaded album is stored in
	 * temp file, if saved then information passed. if not, any change is lost.
	 *
	 * precondition:system is at the album part, no other album loaded or no new
	 *              album is not closed yet. there is at least one album stored
	 *              in the system.
	 *
	 * postcondition: the system is creating loaded album with the user chosen name
	 *                and read to be modified or saved, or closed
	 */	//When Load Album is selected
	public void loadAlbum()
	{

	  if(!albumsExist.exists())
	  {
	  	JOptionPane.showMessageDialog(null,"There are no albums to load!");
	  	menu1new.setEnabled(true);

	  }
	  else
	  {

	      try{
		       BufferedReader in = new BufferedReader(new FileReader(albumListFileR));
		       int counter = 0;
			   int counter2 = 0;
			   String str;
			   while((str = in.readLine()) != null){counter++;}
		       Object[] albumList = new Object[counter];
				in = new BufferedReader(new FileReader(albumListFileR));
			   while((str = in.readLine()) != null){albumList[counter2]=str; counter2++;}
				Object selected = JOptionPane.showInputDialog(null,
                       "Choose one", "Album List",JOptionPane.INFORMATION_MESSAGE, null,albumList, albumList[0]);
	           String albumSelected = (String) selected;

	          if (albumSelected != null)
				 {

				// DB

			   (new File("Album\\temp\\")).mkdir();
			   copyDirectory(new File("Album\\"+albumSelected),new File("Album\\temp\\"+albumSelected));
    	      //End DB

				albumName = albumSelected;

				//enable buttons
				enableButtons(true);

				menu1delete.setEnabled(true);

				saved = false; //since it's jus been loaded
				newAlbum = false; //not new!

				//add page#'s to the ComboBox.
				pageNumB.setEnabled(false);
	            pageNumB.removeActionListener(f);
				currentPageNum = 1;
			    pageNumB.removeAllItems();
		      if(new File("Album\\temp\\"+albumName+"\\NumOfPage.txt").exists())
		       {
				  menu2textT.setEnabled(true);
		          menu2textC.setEnabled(true);

			      in = new BufferedReader(new FileReader("Album\\temp\\"+albumName+"\\NumOfPage.txt"));
			      pageNums = Integer.parseInt(in.readLine());
			      for(int i=0; i<pageNums; i++)
			       {
				      pageNumB.addItem(i+1);
			       }
		        }
				 pageNumB.addActionListener(f);
	          if(pageNums != 0)
			  {
				   pageNumB.setEnabled(true);
			  }

  		     //update GUI (load content)
		     updateAlbumFrame();



		        //test
	         undo.setEnabled(false);

			 }else {
             // User clicked NO for choose album name.
             menu1new.setEnabled(true);
		     menu1load.setEnabled(true);
             }

			}catch(IOException e){}
			}




	}//end loadAlbum


	/*
	 * Class saveAlbum.
	 * Album is saved there is an album loaded or created in the system.
	 *
	 * precondition:system is at the album part, one album is either created or
	 *              loaded
	 *
	 * postcondition: the system saved it.
	 */

	//When Save Album is selected
	public void saveAlbum()
	{
	  try
	  {
	  if (albumsExist.exists()==false)
			{
				albumsExist.createNewFile();
			}
     }catch (IOException e){}

	  //+++++++++++++++++++++++++++++++++++++++++++++++++//
	  //+ (If it's a new album, add name to album list) +//
	  //+ Then, copy album directory with content to    +//
	  //+ Album, overwriting the old one(if exists)     +//
	  //+++++++++++++++++++++++++++++++++++++++++++++++++//
	  if(newAlbum)
	  {
	   try{
	      BufferedReader in = new BufferedReader(new FileReader(albumListFileR));
			PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(albumListFileW)));
			String line = new String();
			while((line=in.readLine()) != null)
			  {
 			    out.println(line);
			  }//end while
		   out.println(albumName);
			in.close();
			out.close();
         // update albumListR with new album name for future album creation and loading.
			in = new BufferedReader(new FileReader(albumListFileW));
		   out = new PrintWriter(new BufferedWriter(new FileWriter(albumListFileR)));
			while((line=in.readLine()) != null){out.println(line);}
			in.close();
			out.close();
         }
		 catch (IOException e){}
		}


		//move album directory from temp to album.
      try{
			 copyDirectory(new File("Album\\temp\\"+albumName),new File("Album\\"+albumName));
	      }
		catch(IOException e){}

	   JOptionPane.showMessageDialog(null,""+albumName+" album is saved");
	   saved = true;

		//test
	   undo.setEnabled(false);

	}//end saveAlbum

	/*
	 * Class deleteAlbum.
	 * Album is deleted if user did not cancel and there is an album loaded or
	 * created in the system.
	 *
	 * precondition:system is at the album part, one album is either created or
	 *              loaded
	 *
	 * postcondition: the system delete it. the album frame deposed.
	 */


	//When Delete Album is selected
	public void deleteAlbum()
	{
	  int value = JOptionPane.showConfirmDialog(null,"Are you sure you want to delete "+albumName+" album?",
	                                            "Delete Album", JOptionPane.YES_NO_OPTION);
	  if (value == 0)
	  {
	   //Delte Directory.Then, delete the album name from the album list
	   try
		  {
		     deleteDirectory(new File("Album\\"+albumName));
		     //write album list to tempFile skipping the deleted album.
		      String line;
			  BufferedReader in = new BufferedReader(new FileReader(albumListFileR));
		      PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(albumListFileW)));
			  int counter = 0;
			  while((line=in.readLine()) != null){counter++;}
			  in.close();
			  in = new BufferedReader(new FileReader(albumListFileR));
			  for(int i=0; i<counter;i++)
			  {
			  	 line = in.readLine();
			  	 if(!(line.equalsIgnoreCase(albumName)))
			  	  {
			  	    out.println(line);
			      }
			  }
			  in.close();
			  out.close();
			  //update albumListR with new list.
			  in = new BufferedReader(new FileReader(albumListFileW));

			  if (in.readLine() == null){boolean b = albumsExist.delete();}

			  out = new PrintWriter(new BufferedWriter(new FileWriter(albumListFileR)));
			  in = new BufferedReader(new FileReader(albumListFileW));
			  while((line=in.readLine()) != null){out.println(line);}
			  in.close();
			  out.close();
			  //update UI
			  albumFrame.hide();
			  pAlbum.updateUI();

			  //enable proper buttons.
			  enableButtons(false);
			  menu1delete.setEnabled(false);
			  menu2textT.setEnabled(false);
		      menu2textC.setEnabled(false);
		      menu2textE.setEnabled(false);
		      menu2textD.setEnabled(false);
		      enableImageButtons(false);
			  menu1new.setEnabled(true);
			  menu1load.setEnabled(true);

         }

	  catch ( IOException e){}

	   JOptionPane.showMessageDialog(null,""+albumName+" is deleted!");

		//test
	   undo.setEnabled(false);

	  }//end if

   }//end deleteAlbum


	/*
	 * Class closeAlbum.
	 * Album is deleted if user did not cancel and there is an album loaded or
	 * created in the system.
	 *
	 * precondition:system is at the album part, one album is either created or
	 *              loaded
	 *
	 * postcondition: the system closed it. the album frame deposed.
	 */

	//When Close Album is selected
	public void closeAlbum()
	{
	  //close album and update UI
	  int value;
	  if (!saved)
	   {
		  value = JOptionPane.showConfirmDialog(null,"Close anyway?","Album not Saved!", JOptionPane.YES_NO_OPTION);
		  if (value == 0)
		   {
			  albumFrame.hide();
			  pAlbum.updateUI();
			  enableButtons(false);
			  menu2textT.setEnabled(false);
		      menu2textC.setEnabled(false);
		      menu2textE.setEnabled(false);
		      menu2textD.setEnabled(false);
			  menu1delete.setEnabled(false);
			  enableImageButtons(false);
			  //test
	        undo.setEnabled(false);
	        menu1new.setEnabled(true);
			menu1load.setEnabled(true);
			try{
			emptyDirectory(new File("Album\\temp"));
		    }catch(IOException e){}

		 }
	   }
       else
		 {
	      albumFrame.hide();
			pAlbum.updateUI();
			enableButtons(false);
			menu2textT.setEnabled(false);
		    menu2textC.setEnabled(false);
		    menu2textE.setEnabled(false);
		    menu2textD.setEnabled(false);
			menu1delete.setEnabled(false);
			enableImageButtons(false);
			//test
	      undo.setEnabled(false);
	      menu1new.setEnabled(true);
		  menu1load.setEnabled(true);

		  //clean up temp file....
		  try{
			emptyDirectory(new File("Album\\temp"));
		  }catch(IOException e){}
		 }

	}//end closeAlbum

	/*
	 * Class addPage.
	 * page is added if there is an album loaded or created in the system.
	 *
	 * precondition:system is at the album part, one album is either created or
	 *              loaded
	 *
	 * postcondition: the system added one page. the album frame update with page numbers
	 */


	//When add page is selected.
	public void addPage()
	{
		pageNums++;

		try{

			PrintWriter fileout = new PrintWriter("Album\\temp\\"+albumName+"\\NumOfPage.txt");
			fileout.println(pageNums);
			fileout.close();

		}catch(IOException e){

			//System.out.println(e);
		}

		Page p = new Page(albumName,pageNums);
		p.storeInfo();
		saved = false;

		//update GUI (load content)
		pageNumB.addItem(pageNums); //add page# to the ComboBox.
		pageNumB.setEnabled(true);
		menu2textT.setEnabled(true);
		menu2textC.setEnabled(true);
		try{updateAlbumFrame();}catch(IOException e){}

	}//end add page

	/*
	 * Class deletePage.
	 * Page is deleted if there is an album loaded or created in the system. At
	 * least one page should be initalized. Since GUI are supported by the database
	 * when u delete a page, need to cut the link first...
	 *
	 * precondition:system is at the album part, one album is either created or
	 *              loaded. at least one page should be initalized.
	 *
	 * postcondition: the system delete it. everything in that page is deleted,
	 *                the next one is replacing this page's textID.
	 */

    public void deletePage()
	{

	 if (currentPageNum != -1)
	 {

		try{
		    pageNums--;

		    // a temp file use for delete
		    (new File("Album\\tempDel")).mkdir();

            copyDirectory(new File("Album\\temp\\"+albumName),new File("Album\\tempDel\\"+albumName));

           //make all the change to the file tempDel
           deleteDirectory(new File("Album\\tempDel\\"+albumName+"\\Page"+currentPageNum));
		     PrintWriter fileout = new PrintWriter("Album\\tempDel\\"+albumName+"\\NumOfPage.txt");
	        fileout.println(pageNums);
	        fileout.close();

		    //rename pages after currentPageNum.
		    for(int k=currentPageNum; k<=pageNums; k++)
		    {
		    	File old = new File("Album\\tempDel\\"+albumName+"\\Page"+(k+1));
			   old.renameTo(new File("Album\\tempDel\\"+albumName+"\\Page"+(k)));
			}

		 }catch(IOException e){}
		 //cut the link of the GUI and temp file
         albumFrame.hide();
		 pAlbum.updateUI();
		 try{
			emptyDirectory(new File("Album\\temp"));
		 }catch(IOException e){}


         //reload it now.
         try{copyDirectory(new File("Album\\tempDel\\"+albumName),new File("Album\\temp\\"+albumName));
         deleteDirectory(new File("Album\\tempDel"));

       //enable buttons
		 enableButtons(true);
		 if (pageNums !=0){
		 	  menu2textT.setEnabled(true);
		      menu2textC.setEnabled(true);
		 }

		 saved = false;

		 //add page#'s to the ComboBox.
		 pageNumB.setEnabled(false);
	     pageNumB.removeActionListener(f);
		 currentPageNum = 1;
		 pageNumB.removeAllItems();

		 if(new File("Album\\temp\\"+albumName+"\\NumOfPage.txt").exists())
		 {
		 	BufferedReader in = new BufferedReader(new FileReader("Album\\temp\\"+albumName+"\\NumOfPage.txt"));
			pageNums = Integer.parseInt(in.readLine());
			for(int i=0; i<pageNums; i++)
			{
				pageNumB.addItem(i+1);
			}
		 }
		 pageNumB.addActionListener(f);
	     pageNumB.setEnabled(true);
         }
         catch ( IOException e )
         {
         	//System.out.println(e);
	     }

		 //update GUI (load content)
		 try{updateAlbumFrame();}catch(IOException e){}


	 }
	}//end deletePage

	/*
	 * Class addText.
	 * Text is added if user did not cancel and there is an album loaded or
	 * created in the system and a page is initalized.
	 *
	 * precondition:system is at the album part, one album is either created or
	 *              loaded,and a page is initalized
	 *
	 * postcondition: the system added one text in the page.
	 */

	//when add text is selected.
   public void addText(boolean isTitle)
	{
	   String content;
		String textType;

	   if(isTitle){textType = "title";}else{textType = "commentary";}

	    content = JOptionPane.showInputDialog("Please type in the "+textType+" you want:");
		 if( content != null)
		 {
		  if(content.hashCode()==0)
		   {
		     JOptionPane.showMessageDialog(null,"No text was entered, please try again or cancel");
			  addText(isTitle);
		   }
		  else
		   {
	        Position p = new Position(0,0);
	        int id = Page.getTextId(currentPageNum,albumName);
	        Text t = new Text(isTitle, content,p,id,albumName,currentPageNum);
	        t.storeInfo();
	        Page.updateTextId(currentPageNum,albumName,id);
			  saved = false;

			  //update GUI (load content)
		     try{updateAlbumFrame();}catch(IOException e){}
		     //test
	         undo.setEnabled(false);

			 menu2textE.setEnabled(true);
		     menu2textD.setEnabled(true);
		   }
		  }
	}//end add text.

	/*
	 * Class editText.
	 * Text is edited if user did not cancel and there is an album loaded or
	 * created in the system and a page is initalized, user chosen on text.
	 *
	 * precondition:system is at the album part, one album is either created or
	 *              loaded,and a page is initalized,user chosen one text.
	 *
	 * postcondition: the system edit the text chosen to user input in the page.
	 */

	//when editText is selected.
   public void editText()
	 {
	   if(textSelected == -1){JOptionPane.showMessageDialog(null,"No text was selected!");}
		else
		 {
		   String content = JOptionPane.showInputDialog("Enter new text");
		   if( content != null)
		    {
		     if(content.hashCode()==0)
		     {
		       JOptionPane.showMessageDialog(null,"No text was entered, please try again or cancel");
			    editText();
		     }
			 else
			  {
			    Text.storeInfo(albumName,currentPageNum,textSelected,content);
			    saved = false;
		        try{updateAlbumFrame();}catch(IOException e){}
		        //test
	            undo.setEnabled(false);
			  }
			 }
		  }
	 }//end editText.

	/*
	 * Class deleteText.
	 * Text is deleted if user did not cancel and there is an album loaded or
	 * created in the system and a page is initalized, user chosen on text.
	 *
	 * precondition:system is at the album part, one album is either created or
	 *              loaded,and a page is initalized,user chosen one text.
	 *
	 * postcondition: the system delete the text that user chosen, update other
	 *                files to have no gaps in database.
	 */

	//when deleteText is selected.
	public void deleteText()
	 {

		try{
		 if(textSelected != -1)
		 {
		   int value = JOptionPane.showConfirmDialog(null,"Are you sure you want to delete this text?",
	                                            "Delete Text", JOptionPane.YES_NO_OPTION);
	     if (value == 0)
	     {
		  //System.out.println(textSelected);
		  File txt = new File("Album\\temp\\"+albumName+"\\Page"+currentPageNum+"\\Text"+textSelected+".txt");
		  txt.delete();
		  textNums--;
		  PrintWriter fileout = new PrintWriter("Album\\temp\\"+albumName+"\\Page"+currentPageNum+"\\numOfText.txt");
	     fileout.println(textNums);
	     fileout.close();

		  File old = new File("");
		  //rename texts after textSelected.
		  for(int k=0; k<=(textNums-textSelected); k++)
		   {
			  old = new File("Album\\temp\\"+albumName+"\\Page"+currentPageNum+"\\Text"+(k+1+textSelected)+".txt");
			  old.renameTo(new File("Album\\temp\\"+albumName+"\\Page"+currentPageNum+"\\Text"+(k+textSelected)+".txt"));
			}

		  saved = false;
		  updateAlbumFrame();
		  //test
	     undo.setEnabled(false);
		 }
		 }
		}catch(IOException e){}


	 }//end deleteText.

	/*
	 * Class addImage.
	 * Image is added if the album and page is at created or loaded stage and when
	 * an image is selcted from the search results POP UP WINDOW and the ADD is
	 * clicked.The Image is added at the page, write to the album directory in the
	 * speicified page number
	 *
	 * precondition:Image is added if the album and page is at created or loaded stage and when
	 *              an image is selcted from the search results POP UP WINDOW and the ADD is
	 *              clicked
	 *
	 * postcondition: The Image is added at the page, write to the album directory in the
	 *                speicified page number
	 */
	//when an image is selcted from the search results POP UP WINDOW and the ADD is clicked.
	public void addImage()
	 {

		Position p = new Position(0,0);
		try{
		BufferedImage src = ImageIO.read(new File("Repository\\"+imageID+"."+fileExt.getFileExt(imageID)));
		Position pCX = new Position(0,0);
		Position pCY = new Position(src.getWidth(),src.getHeight());
		int id = Page.getImageId(currentPageNum,albumName);
		ImageDB im = new ImageDB("Repository\\"+imageID+"."+fileExt.getFileExt(imageID), p, 1, 1, pCX,pCY, 0.0,id,albumName,currentPageNum);
		im.storeInfo();
		Page.updateImageId(currentPageNum,albumName,id);
		}catch(IOException e){}
		saved = false;
		try{updateAlbumFrame();}catch(IOException e){}
		//test
	   undo.setEnabled(false);
	 }//end add image.



	/*
	 * Class resizeImage.
	 * Image is resized if the album and page is at created or loaded stage and when
	 * an image is selcted from the page of the album and user speicified a number to
	 * resizeThe Image i. If not cancelled, update the album directory in the
	 * speicified page number and GUI.enlarge if the input is larger than 1, make smaller
	 * if it is smaller than 1
	 *
	 * precondition:Image is resized if the album and page is at created or loaded stage and when
	 *              an image is selcted from the page of the album and user speicified a number to
	 *              resizeThe Image i,which should be two numbers indicate how to resize
	 *              x and y.
	 *
	 * postcondition: If not cancelled, update the album directory in the
	 *                speicified page number and GUI.enlarge if the input is larger than 1,
	 *                make smallerif it is smaller than 1
	 */
  //when resizeImage is selected.
  public void resizeImage()
   {
	  //get the imageID
	  Integer ImageID = getImageID(new File(Page.getImageDir(currentPageNum, albumName, imageSelected)));
	  //create a temp to store image preview
	  Image imgPreview = null;

	  //get the extension of the image
	  final String FileExt = fileExt.getFileExt(ImageID);
	  //get set the file to open thumbnail
	  final File fImage = new File("Repository/"+ImageID+"tmb."+FileExt);
	  //try loading the thumbnail image
	  try
	  {
		//load in thumbnail image
		imgPreview = ImageIO.read(fImage);
	  }
	  catch (Exception e) {}

	  //create a frame for popup dialog
	  Frame window = new Frame();
	  //create panels for the dialog
      JPanel pPreviewImage = new JPanel();
	  JPanel pOptions = new JPanel();
	  JPanel pInput = new JPanel();

	  pInput.setLayout(new GridBagLayout());


	  //create label for input boxes
	  JLabel ContX = new JLabel("Width Resize Value ");
	  JLabel ContY = new JLabel("Height Resize Value ");
	  final JLabel ResizeNum = new JLabel("X: 1.0  Y: 1.0");

	  //create textfield for input boxes
	  final Scrollbar XValue = new Scrollbar(Scrollbar.HORIZONTAL, 10, 1, 0, 100);
	  final Scrollbar YValue = new Scrollbar(Scrollbar.HORIZONTAL, 10, 1, 0, 100);

	  //set textfield width
	  XValue.setPreferredSize(new Dimension(100,25));
	  YValue.setPreferredSize(new Dimension(100,25));

	  //add textfield and inputboxes to input panel
	  addComponents(ContX,XValue,pInput);
	  addComponents(ContY,YValue,pInput);

	  //set title for the dialog
      dlgResize = new JDialog(window, "Resize Image", true);

      //set layout for the dialog
      dlgResize.setLayout(new BorderLayout());

      // Create an OK button
	  JButton resize = new JButton ("Resize");
	  JButton cancel = new JButton("Cancel");

	  //set layout for the subpanel
	  pOptions.setLayout(new GridLayout(1,2));

	  //add the buttons to the panel
	  pOptions.add(resize);
	  pOptions.add(cancel);

	  //add thumbnail to label
	  pPreviewImage.add(new JLabel(new ImageIcon(imgPreview)));
	  //add a label to warn user
	  pPreviewImage.add(new JLabel("Enter the width resize value (1=no chang; 2=double size)"));
	  pPreviewImage.add(ResizeNum);
	  //set preferred size
	  pPreviewImage.setPreferredSize(new Dimension(300,300));
	  pOptions.setPreferredSize(new Dimension(400,30));
	  pInput.setPreferredSize(new Dimension(400,100));

	  //add subpanel to main dialog
	  dlgResize.add(pPreviewImage, BorderLayout.NORTH);
	  dlgResize.add(pInput, BorderLayout.CENTER);
	  dlgResize.add(pOptions, BorderLayout.SOUTH);

	  //add action listeners for the dialog
	  resize.addActionListener ( new ActionListener()
	  {
		public void actionPerformed( ActionEvent e )
		{

	  		double contentX = XValue.getValue()/10.0;
	  		double contentY = YValue.getValue()/10.0;

			previousSize = Page.getImageSize(currentPageNum, albumName, imageSelected);
			editType = 1;
			imageEdited = imageSelected;
			undo.setEnabled(true);
			ImageDB.storeInfo(albumName,currentPageNum,imageSelected,contentX, contentY);
			saved = false;
			try{updateAlbumFrame();}catch(IOException ae){}
			dlgResize.dispose();
		}
	  });

	  //if cancel is selected
	  cancel.addActionListener ( new ActionListener()
	  {
		public void actionPerformed( ActionEvent e )
		{
			//close dialog
			dlgResize.removeAll();
			dlgResize.dispose();
		}
	  });

	  //when slider move, change the label
	  XValue.addAdjustmentListener(new AdjustmentListener ()
	  {
		public void adjustmentValueChanged(AdjustmentEvent e) {
			ResizeNum.setText("X: "+XValue.getValue()/10.0+"  Y: "+YValue.getValue()/10.0);
	  }});

	   YValue.addAdjustmentListener(new AdjustmentListener ()
	  {
		public void adjustmentValueChanged(AdjustmentEvent e) {
			ResizeNum.setText("X: "+XValue.getValue()/10.0+"  Y: "+YValue.getValue()/10.0);
	  }});

	  imgPreview.flush();
	  //set dialog preferred size
	  dlgResize.setPreferredSize(new Dimension(400,500));
	  dlgResize.pack();
	  //centre the dialog
	  dlgResize.setLocationRelativeTo(null);
	  //show dialog
	  dlgResize.setVisible(true);

	}//end resizeImage.
	/*
	 * Class cropImage.
	 * Image is cropped if the album and page is at created or loaded stage and when
	 * an image is selcted from the page of the album and user speicified two numbers
	 * inputted to set a square for the cropping.update the album directory in the
	 * speicified page number and GUI.crop it if the input is not the whole image or
	 * over
	 *
	 * precondition:Image is cropped if the album and page is at created or loaded stage and when
	 *              an image is selcted from the page of the album and user speicified two numbers
	 *              inputted to set a square for the cropping.two poisition is inputted correctly.
	 *
	 * postcondition: If not cancelled, update the album directory in the
	 *               speicified page number and GUI.crop it if the input is not the whole image or
	 *                over
	 */
	//when cropImage is selected.
  public void cropImage()
   {
	  Integer ImageID = getImageID(new File(Page.getImageDir(currentPageNum, albumName, imageSelected)));
	  //create a temp to store Original image
	  BufferedImage imgOriginal = null;
	  //create a temp to store image preview
	  Image imgPreview = null;

	  //get the extension of the image
	  final String FileExt = fileExt.getFileExt(ImageID);
	  //get the original image file
	  final File OriginalImage = new File("Repository/"+ImageID.toString()+"."+FileExt);
	  try
	  {
		//load in thumbnail image
		imgOriginal = ImageIO.read(OriginalImage);
	  }
	  catch (Exception e) {}

	  //get size of the original image
	  final int imgWidth = imgOriginal.getWidth();
	  final int imgHeight = imgOriginal.getHeight();


	  //remove buffer image from memory
	  imgOriginal.flush();
	  //get set the file to open thumbnail
	  final File fImage = new File("Repository/"+ImageID.toString()+"tmb."+FileExt);
	  //try loading the thumbnail image
	  try
	  {
		//load in thumbnail image
		imgPreview = ImageIO.read(fImage);
	  }
	  catch (Exception e) {}

	  //create a frame for popup dialog
	  Frame window = new Frame();
	  //create panels for the dialog
      JPanel pPreviewImage = new JPanel();
	  JPanel pOptions = new JPanel();
	  JPanel pInput = new JPanel();

	  pInput.setLayout(new GridBagLayout());
	  final JLabel Xpos = new JLabel("  Left X: 0  Right X: "+imgWidth);
	  final JLabel Ypos = new JLabel("  Left Y: 0  Right Y: "+imgHeight);

	  //create label for input boxes
	  JLabel initX = new JLabel("Initial X Value");
	  JLabel finalX = new JLabel("Final X Value");
	  JLabel initY = new JLabel("Initial Y Value");
	  JLabel finalY = new JLabel("Final Y Value");

	  final Scrollbar initXValue = new Scrollbar(Scrollbar.HORIZONTAL, 0, 1, 0, imgWidth);
	  final Scrollbar finalXValue = new Scrollbar(Scrollbar.HORIZONTAL, imgWidth, 1, 0, imgWidth);
	  final Scrollbar initYValue = new Scrollbar(Scrollbar.HORIZONTAL, 0, 1, 0, imgHeight);
	  final Scrollbar finalYValue = new Scrollbar(Scrollbar.HORIZONTAL, imgHeight, 1, 0, imgHeight);


	  //set textfield width
	  initXValue.setPreferredSize(new Dimension(100,25));
	  finalXValue.setPreferredSize(new Dimension(100,25));
	  initYValue.setPreferredSize(new Dimension(100,25));
	  finalYValue.setPreferredSize(new Dimension(100,25));

	  //add textfield and inputboxes to input panel
	  addComponents(initX,initXValue,pInput);
	  addComponents(finalX,finalXValue,pInput);
	  addComponents(initY,initYValue,pInput);
	  addComponents(finalY,finalYValue,pInput);

	  //set title for the dialog
      dlgCrop = new JDialog(window, "Crop Image", true);

      //set layout for the dialog
      dlgCrop.setLayout(new BorderLayout());

      // Create an OK button
	  JButton crop = new JButton ("Crop");
	  JButton cancel = new JButton("Cancel");

	  //set layout for the subpanel
	  pOptions.setLayout(new GridLayout(1,2));

	  //add the buttons to the panel
	  pOptions.add(crop);
	  pOptions.add(cancel);

	  //add thumbnail to label
	  pPreviewImage.add(new JLabel(new ImageIcon(imgPreview)));
	  //add a label to show user current scrollbar value
	  pPreviewImage.add(new JLabel("Select the Initial and Final values:"));
	  pPreviewImage.add(new JLabel("                                  "));
	  pPreviewImage.add(Xpos);
	  pPreviewImage.add(Ypos);
	  //set preferred size
	  pPreviewImage.setPreferredSize(new Dimension(300,300));
	  pOptions.setPreferredSize(new Dimension(400,30));
	  pInput.setPreferredSize(new Dimension(400,100));

	  //add subpanel to main dialog
	  dlgCrop.add(pPreviewImage, BorderLayout.NORTH);
	  dlgCrop.add(pInput, BorderLayout.CENTER);
	  dlgCrop.add(pOptions, BorderLayout.SOUTH);

	  //add action listeners for the dialog
	  crop.addActionListener ( new ActionListener()
	  {
		public void actionPerformed( ActionEvent e )
		{

	  		int iX = initXValue.getValue();
	  		int fX = finalXValue.getValue();
	  		int iY = initYValue.getValue();
	  		int fY = finalYValue.getValue();

	 		if (iX>fX || iY>fY)
	 		{
	 			JOptionPane.showMessageDialog(null,"Value Entered Must Be Numerical and Non-Empty");
	 		}

	 		else
	 		{
				previousCrop = Page.getImageCrop(currentPageNum, albumName, imageSelected);
				editType = 2;
				imageEdited = imageSelected;
				undo.setEnabled(true);
				Position pCX = new Position(iX,iY);
				Position pCY = new Position(fX,fY);
				ImageDB.storeInfo(albumName,currentPageNum,imageSelected, pCX,pCY, true);
				saved = false;
				try{updateAlbumFrame();}catch(IOException ae){}
				dlgCrop.dispose();
			}
		}
	  });

	  //if cancel is selected
	  cancel.addActionListener ( new ActionListener()
	  {
		public void actionPerformed( ActionEvent e )
		{
			//close dialog
			dlgCrop.removeAll();
			dlgCrop.dispose();
		}
	  });

	  initXValue.addAdjustmentListener(new AdjustmentListener ()
	  {
		public void adjustmentValueChanged(AdjustmentEvent e) {
			Xpos.setText("  Left X: "+initXValue.getValue()+" Right X: "+finalXValue.getValue());
	  }});

	  finalXValue.addAdjustmentListener(new AdjustmentListener ()
	  {
		public void adjustmentValueChanged(AdjustmentEvent e) {
			Xpos.setText("  Left X: "+initXValue.getValue()+" Right X: "+finalXValue.getValue());
	  }});

	  initYValue.addAdjustmentListener(new AdjustmentListener ()
	  {
		public void adjustmentValueChanged(AdjustmentEvent e) {
			Ypos.setText("  Left Y: "+initYValue.getValue()+" Right Y: "+finalYValue.getValue());
	  }});

	  finalXValue.addAdjustmentListener(new AdjustmentListener ()
	  {
		public void adjustmentValueChanged(AdjustmentEvent e) {
			Ypos.setText("  Left Y: "+initYValue.getValue()+" Right Y: "+finalYValue.getValue());
	  }});

	  imgPreview.flush();
	  //set dialog preferred size
	  dlgCrop.setPreferredSize(new Dimension(400,500));
	  dlgCrop.pack();
	  //centre the dialog
	  dlgCrop.setLocationRelativeTo(null);
	  //show dialog
	  dlgCrop.setVisible(true);

	}//end cropImage.

	/*
	 * Class rotateImage.
	 * Image is rotated if the album and page is at created or loaded stage and when
	 * an image is selcted from the page of the album and user speicified a number of
	 * degree to resizeThe Image i. If not cancelled, update the album directory in the
	 * speicified page number and GUI
	 *
	 * precondition:Image is resized if the album and page is at created or loaded stage and when
	 *              an image is selcted from the page of the album and user speicified a number of
	 *              degree to rotate Image,which should be 0-360.
	 *
	 * postcondition: If not cancelled, update the album directory in the
	 *                speicified page number and GUI
	 */
	//rotate image.

  public void rotateImage()
   {
	  //get the imageID
	  Integer ImageID = getImageID(new File(Page.getImageDir(currentPageNum, albumName, imageSelected)));
	  //create a temp to store image preview
	  Image imgPreview = null;

	  //get the extension of the image
	  final String FileExt = fileExt.getFileExt(ImageID);
	  //get set the file to open thumbnail
	  final File fImage = new File("Repository/"+ImageID+"tmb."+FileExt);
	  //try loading the thumbnail image
	  try
	  {
		//load in thumbnail image
		imgPreview = ImageIO.read(fImage);
	  }
	  catch (Exception e) {}



	  //create a frame for popup dialog
	  Frame window = new Frame();
	  //create panels for the dialog
      JPanel pPreviewImage = new JPanel();
	  JPanel pOptions = new JPanel();
	  JPanel pInput = new JPanel();

	  pInput.setLayout(new GridBagLayout());


	  //create label for input boxes
	  JLabel ContD = new JLabel("Width Resize Value ");
	  final JLabel RotateNum = new JLabel("Degree:" + previousRotation);

	  //create textfield for input boxes
	  final Scrollbar DValue = new Scrollbar(Scrollbar.HORIZONTAL, 0, 1, 0, 360);

	  //set textfield width
	  DValue.setPreferredSize(new Dimension(100,25));

	  //add textfield and inputboxes to input panel
	  addComponents(ContD,DValue,pInput);

	  //set title for the dialog
      dlgRotate = new JDialog(window, "Rotate Image", true);

      //set layout for the dialog
      dlgRotate.setLayout(new BorderLayout());

      // Create an OK button
	  JButton rotate = new JButton ("Rotate");
	  JButton cancel = new JButton("Cancel");

	  //set layout for the subpanel
	  pOptions.setLayout(new GridLayout(1,2));

	  //add the buttons to the panel
	  pOptions.add(rotate);
	  pOptions.add(cancel);

	  //add thumbnail to label
	  pPreviewImage.add(new JLabel(new ImageIcon(imgPreview)));
	  //add a label to warn user
	  pPreviewImage.add(new JLabel("Enter the rotating degree"));
	  pPreviewImage.add(RotateNum);
	  //set preferred size
	  pPreviewImage.setPreferredSize(new Dimension(300,300));
	  pOptions.setPreferredSize(new Dimension(400,30));
	  pInput.setPreferredSize(new Dimension(400,100));

	  //add subpanel to main dialog
	  dlgRotate.add(pPreviewImage, BorderLayout.NORTH);
	  dlgRotate.add(pInput, BorderLayout.CENTER);
	  dlgRotate.add(pOptions, BorderLayout.SOUTH);

	  //add action listeners for the dialog
	  rotate.addActionListener ( new ActionListener()
	  {
		public void actionPerformed( ActionEvent e )
		{

	  		double contentD = DValue.getValue();

			previousRotation = Page.getImageRotation(currentPageNum, albumName, imageSelected);
			editType = 3;
			imageEdited = imageSelected;
			undo.setEnabled(true);
			ImageDB.storeInfo(albumName, currentPageNum, imageSelected, contentD);
			saved = false;
			try{updateAlbumFrame();}catch(IOException ae){}
			dlgRotate.dispose();
		}
	  });

	  //if cancel is selected
	  cancel.addActionListener ( new ActionListener()
	  {
		public void actionPerformed( ActionEvent e )
		{
			//close dialog
			dlgRotate.removeAll();
			dlgRotate.dispose();
		}
	  });

	  //when slider move, change the label
	  DValue.addAdjustmentListener(new AdjustmentListener ()
	  {
		public void adjustmentValueChanged(AdjustmentEvent e) {
			RotateNum.setText("Degree: "+DValue.getValue());
	  }});

	  imgPreview.flush();
	  //set dialog preferred size
	  dlgRotate.setPreferredSize(new Dimension(400,500));
	  dlgRotate.pack();
	  //centre the dialog
	  dlgRotate.setLocationRelativeTo(null);
	  //show dialog
	  dlgRotate.setVisible(true);

	}//end rotateImage.

	/*
	 * Class deleteImage.
	 * Image is deleted if the album and page is at created or loaded stage and when
	 * an image is selcted. delete after pressing and delete asoociated image in database
	 * image dispappear from the album
	 *
	 * precondition:Image is deleted if the album and page is at created or loaded stage and when
	 *                an image is selcted..
	 *
	 * postcondition: delete after pressing and delete asoociated image in database, image dispappear
	 *                from the album
	 */


//when deleteImage is selected.
	public void deleteImage()
	 {
	   int value;
		try{
		 if(imageSelected > 0)
		 {
		  if(systemDelete)
		  {
		    value = 0;
		  }
		  else
		  {
		    value = JOptionPane.showConfirmDialog(null,"Are you sure you want to delete this image?",
	                                             "Delete Image", JOptionPane.YES_NO_OPTION);
		  }

		  if (value == 0)
	     {
		  //System.out.println(imageSelected);
		  File img = new File("Album\\temp\\"+albumName+"\\Page"+currentPageNum+"\\Image"+imageSelected+".txt");
		  img.delete();
		  imageNums--;
		  PrintWriter fileout = new PrintWriter("Album\\temp\\"+albumName+"\\Page"+currentPageNum+"\\numOfImage.txt");
	     fileout.println(imageNums);
	     fileout.close();

		  File old = new File("");
		  //rename texts after imageSelected.
		  for(int k=0; k<=(imageNums-imageSelected); k++)
		   {
			  old = new File("Album\\temp\\"+albumName+"\\Page"+currentPageNum+"\\Image"+(k+1+imageSelected)+".txt");
			  old.renameTo(new File("Album\\temp\\"+albumName+"\\Page"+currentPageNum+"\\Image"+(k+imageSelected)+".txt"));
			}

		  saved = false;
		  updateAlbumFrame();
		  //test
	     undo.setEnabled(false);
		 }}
		}catch(IOException e){}


	 }//end deleteImage.


	/*
	 * Class undo.
	 * Image is going to be change back, if the previous step of modification is not statisfied.click
	 * undo will bring back the last step status of the image.
	 *
	 * precondition:one step of modification has been succesfully done with a image.
	 *
	 * postcondition: get the status of image before last modification, update database.
	 */
	public void undo()
	{
	  if(editType == 1){ImageDB.storeInfo(albumName,currentPageNum,imageEdited,previousSize[0], previousSize[1],true);}
	  else if(editType == 2){ImageDB.storeInfo(albumName,currentPageNum,imageEdited,previousCrop[0],previousCrop[1],true);}
	  else if(editType == 3){ImageDB.storeInfo(albumName, currentPageNum, imageEdited, previousRotation);}
	  undo.setEnabled(false);
	  try{updateAlbumFrame();}catch(IOException e){}
	}//end test


	public  void UpdateSearchUI()
	{
		pSearch.updateSelectPanel();
	}




   public void enableButtons(boolean bool)
   {
	      menu1save.setEnabled(bool);
		  menu1close.setEnabled(bool);
		  //menu1delete.setEnabled(bool);
		  //menu2textT.setEnabled(bool);
		  //menu2textC.setEnabled(bool);
	      //menu2textE.setEnabled(bool);
	      //menu2textD.setEnabled(bool);
	      //menu2imageC.setEnabled(bool);
	      //menu2imageRe.setEnabled(bool);
	      //menu2imageRo.setEnabled(bool);
	      //menu2imageD.setEnabled(bool);
	      menu2pageA.setEnabled(bool);
	      menu2pageD.setEnabled(bool);
	}

	public void enableImageButtons(boolean bool)
	{
		  menu2imageC.setEnabled(bool);
	      menu2imageRe.setEnabled(bool);
	      menu2imageRo.setEnabled(bool);
	      menu2imageD.setEnabled(bool);
	}

 	/*
	 * Class updateAlbumFrame()
	 * This function actually read from the database and display the album. it
	 * includes severl subparts, such as: display texts, display images and display
	 * the editting effect on the image
	 *
	 * preconidition: when album GUI needs to be updated
	 * postcondition: the update on GUI is done as well as the database.
	 */

    public void updateAlbumFrame()throws IOException
    {
      pAlbumCenter.removeAll();
	  try{
		  if(new File("Album\\temp\\"+albumName+"\\NumOfPage.txt").exists())
		   {
			  BufferedReader in = new BufferedReader(new FileReader("Album\\temp\\"+albumName+"\\NumOfPage.txt"));
	        pageNums = Integer.parseInt(in.readLine());
			  in.close();
			}


		  //display texts.
		  if(new File("Album\\temp\\"+albumName+"\\page"+currentPageNum+"\\numOfText.txt").exists() && currentPageNum > 0)
		  {
			  BufferedReader in = new BufferedReader(new FileReader("Album\\temp\\"+albumName+"\\page"+currentPageNum+"\\numOfText.txt"));
	          textNums = Integer.parseInt(in.readLine());
			  in.close();

			  if(textNums !=0){

			   menu2textE.setEnabled(true);
		      menu2textD.setEnabled(true);

		      }else{

		        menu2textE.setEnabled(false);
		        menu2textD.setEnabled(false);
		      }

			  textL = new JLabel[textNums];

		  for(int i=1; i<=textNums; i++)
		   {
			  String textValue = Page.getTextValue(currentPageNum, albumName, i);
			  boolean isTitle = Page.getTextType(currentPageNum, albumName, i);
			  textL[i-1] = new JLabel();
			  textL[i-1].setText(textValue);
			  if(isTitle){
			     if(textValue.length()>4){textL[i-1].setSize(textValue.length()*11,15);}
				  else{textL[i-1].setSize(50,15);}
				  textL[i-1].setFont(new Font("Arial", Font.BOLD, 18));
				           }
			  else{
			     if(textValue.length()>4){textL[i-1].setSize(textValue.length()*10,15);}
				  else{textL[i-1].setSize(45,15);}
				  textL[i-1].setFont(new Font("Arial", Font.BOLD, 12));
					}
			  textL[i-1].setVisible(false);
			  pAlbumCenter.add(textL[i-1]);
			  textL[i-1].setLocation(Page.getTextPos(currentPageNum, albumName, i).getX(),Page.getTextPos(currentPageNum, albumName, i).getY());
			  textL[i-1].setVisible(true);

			  //
			  textL[i-1].addMouseMotionListener(new moveIconHandler());
			  //

			  textL[i-1].addMouseListener(new java.awt.event.MouseAdapter() {
           public void mouseClicked(java.awt.event.MouseEvent evt) {
                LabelMouseClicked(evt);}});

			 }


		  //display images.
		  if(new File("Album\\temp\\"+albumName+"\\page"+currentPageNum+"\\numOfImage.txt").exists())
		   {
			  in = new BufferedReader(new FileReader("Album\\temp\\"+albumName+"\\page"+currentPageNum+"\\numOfImage.txt"));
	          imageNums = Integer.parseInt(in.readLine());

	          if(imageNums != 0){

	          	enableImageButtons(true);
	          }else{

	          	enableImageButtons(false);
	          }

			  in.close();
			  imageL = new JLabel[imageNums];

		  for(int i=1; i<=imageNums; i++)
		   {
			  String imageDir = Page.getImageDir(currentPageNum, albumName, i);

			  if (!(new File(imageDir).exists()))
			  {
			  int temp = imageSelected;
			  imageSelected = i;
			  systemDelete = true;
			  deleteImage();
			  systemDelete = false;
			  imageSelected = temp;
			  }else{

			  double[] imageSize = new double[2];
			  Position[] crop = new Position[2];
			  double rotation = Page.getImageRotation(currentPageNum, albumName, i);
			  imageSize = Page.getImageSize(currentPageNum, albumName, i);
			  crop = Page.getImageCrop(currentPageNum, albumName, i);
			  int x1 = crop[0].getX();
			  int y1 = crop[0].getY();
			  int x2 = crop[1].getX();
			  int y2 = crop[1].getY();
			  imageL[i-1] = new JLabel();
			  double labelH = imageSize[0];
			  double labelW = imageSize[1];

			  try{
			  	ImageBuffer = ImageIO.read(new File(imageDir));
			  }catch (Exception e) {System.out.println("imageBuffer read error");}

			  double origH = y2;
			  double origW = x2;


			  //________________CROP_________________________
			  try
			  {
				BufferedImage bi = ImageBuffer.getSubimage(x1, y1, x2-x1, y2-y1);
				ImageBuffer = bi;
			  }
			  catch (RasterFormatException e) {System.out.println("No Crop Need");}
			  //_______________END___CROP____________________

			  //_______________ROTATION_____________________
			  ImageBuffer = Tilt.tilt(ImageBuffer,rotation);
			  //____________END_______ROTATION______________
			  iImage = ImageBuffer;


			  //_______________RESIZE_________________________
			  int disH = (int) (labelH*(iImage.getHeight(null)));
			  int disW = (int) (labelW*(iImage.getWidth(null)));
			  iImage = iImage.getScaledInstance(disW, disH, Image.SCALE_FAST); //problems here.
			  //____________END___RESIZE_____________________




              imageL[i-1].setIcon(new ImageIcon(iImage));
			  imageL[i-1].setSize(disW+4,disH+4);
			  imageL[i-1].setVisible(false);
			  pAlbumCenter.add(imageL[i-1]);
			  imageL[i-1].setLocation(Page.getImagePos(currentPageNum, albumName, i).getX(),Page.getImagePos(currentPageNum, albumName, i).getY());
			  imageL[i-1].setVisible(true);

			  ImageBuffer.flush();
			  iImage.flush();

			  //
			  imageL[i-1].addMouseMotionListener(new moveIconHandler());
			  //

			  imageL[i-1].addMouseListener(new java.awt.event.MouseAdapter() {
           public void mouseClicked(java.awt.event.MouseEvent evt) {
                LabelMouseClicked(evt);}});

			} }
		  }


			}
        }
		catch (IOException e){}

		//++++++++++++++++++++++++++++++++++++++++++++++++//
		// we should use the variable 'currentPageNum' to //
		// display images and texts that are in that      //
		// page ( we only have text and they're all in    //
		// position (0,0) for now).                       //
		//++++++++++++++++++++++++++++++++++++++++++++++++//

		albumFrame.add(pageNumB,BorderLayout.NORTH);
		albumFrame.setTitle(albumName);
	    albumFrame.pack();
	    albumFrame.show();
		albumFrame.updateUI();
		saved = false;
		textSelected = -1;
		imageSelected = -1;

	}

 	/*
	 * Class moveIconHandler()
	 * This function actually read the user's mouse movement and can handle the
	 * drag of text and image to a position user want.
	 *
	 * precondition: image or text is selected, move the position to another poisition.
	 *
	 * postcondition: change its poisiton from the original to a new one.
	 */
//
  private class moveIconHandler extends MouseMotionAdapter {
   public void mouseDragged(MouseEvent e) {
    if (textSelected > 0)
	 {
     Component c = e.getComponent();
     c.setLocation( c.getX()+e.getX(), c.getY()+e.getY() );
     Text.storeInfo(albumName,currentPageNum,textSelected,new Position(c.getX()+e.getX(), c.getY()+e.getY()));
     pAlbumCenter.repaint();
	 }
	 else
	 {
	  if(imageSelected < 1){return;}
	  Component c = e.getComponent();
     c.setLocation( c.getX()+e.getX(), c.getY()+e.getY() );
     ImageDB.storeInfo(albumName,currentPageNum,imageSelected ,new Position(c.getX()+e.getX(), c.getY()+e.getY()));
     pAlbumCenter.repaint();
	 }
    }
   }
//

	/*
	 * Class LabelMouseClicked()
	 * This function helps user to choose text, image, click once to select it. once
	 * select, it is in blue.
	 *
	 * precondition: the image or text is on the page of an album and has been clicked.
	 *
	 * postcondition: it turns the color of background to blue and is selected and able
	 *                to do further modification.
	 */
  public void LabelMouseClicked(MouseEvent e)
  {
	for(int i = 0;i < textNums;i ++)
	{
	  textL[i].setBackground(Color.lightGray);
   }

	for(int i = 0;i < imageNums;i ++)
	{
	  imageL[i].setBackground(Color.lightGray);
   }

	for(int i = 0;i < textNums;i ++)
	 {
	  if (e.getSource() == textL[i])
	   {
		 textL[i].setOpaque(true);
		 textL[i].setBackground(Color.BLUE);
	    textSelected = i+1;
	    }
	  }

	 for(int i = 0;i < imageNums;i ++)
	 {
	  if (e.getSource() == imageL[i])
	   {
		 imageL[i].setOpaque(true);
		 imageL[i].setBackground(Color.BLUE);
	    imageSelected = i+1;
	    }
	  }


	 if (e.getSource() == pAlbumCenter)
		{
		  textSelected = -1;
		  imageSelected = -1;
		  for(int j = 0;j < textNums;j ++)
		  {
		   textL[j].setBackground(Color.lightGray);
		  }
		  for(int j = 0;j < imageNums;j ++)
		  {
		   imageL[j].setBackground(Color.lightGray);
		  }
		  try{updateAlbumFrame();}catch(IOException r){}
		}

  }







//-----------------END-OF-METHEDS------------------
//----------------HELPER--FUNCTIONS----------------
	/*
	 * Class deleteDirectory
	 * This method will be delete every content of file path pass by parameter
	 *
	 * precondition: there exists a directory as the parameter indicates
	 *
	 * postcondition: Any content of the directory is gone.
	 */
  public void deleteDirectory(File path)
   throws IOException
   {
	 File[] files = path.listFiles();

     for(int i=0; i<files.length; ++i)
     {
      if(files[i].isDirectory())
         deleteDirectory(files[i]);

      files[i].delete();
     }
	 path.delete();
   }
	/*
	 * Class emptyDirectory
	 * This method will be empty every content under the file path pass by parameter
	 *
	 * precondition: there exists a directory as the parameter indicates
	 *
	 * postcondition: any content under it is gone.
	 */

  public void emptyDirectory(File path)
   throws IOException
   {
	 File[] files = path.listFiles();

     for(int i=0; i<files.length; ++i)
     {
      if(files[i].isDirectory())
         deleteDirectory(files[i]);

      files[i].delete();
     }

   }
	/*
	 * Class copyDirectory
	 * This method will be useful as well in the view.java, which copy the content
	 * of one directory to an other.
	 *
	 * precondition: exist two directory
	 *
	 * postcondition : one have the same content as the other
	 */

	public void copyDirectory(File sourceLocation , File targetLocation)
    throws IOException {

        if (sourceLocation.isDirectory()) {
            if (!targetLocation.exists()) {
                targetLocation.mkdir();
            }

            String[] children = sourceLocation.list();
            for (int i=0; i<children.length; i++) {
                copyDirectory(new File(sourceLocation, children[i]),
                        new File(targetLocation, children[i]));
            }
        } else {

            InputStream in = new FileInputStream(sourceLocation);
            OutputStream out = new FileOutputStream(targetLocation);

            // Copy the bits from instream to outstream
            byte[] buf = new byte[1024];
            int len;
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            in.close();
            out.close();
        }
    }

    /**
     * getImageID
     * This function takes the file path and get the ImageID of that file
     *
     * Precondition : File must exists
     * Postcondition : The ImageID of the file is returned
     */
    public static Integer getImageID(File f)
    {
        String FileName = null;
        String s = f.getName();
        int i = s.lastIndexOf('.');

       if (i > 0 &&  i < s.length() - 1)
        {
            FileName = s.substring(0,i).toLowerCase();
        }
        //System.out.println(FileName);
        return Integer.parseInt(FileName);
    }

    /**
     * OnlyNumeric
     * This function takes a string and check to see if it is numerical
     * Precondition : String not null or empty
     * Postcondition : return true if string is numerical
     */
    public boolean OnlyNumericAndNonEmpty(String str)
    {
		if (str.length()==0)
			return false;
		//for each character of the string check to see if numerical
		for (int i=0;i<str.length();i++)
		{
			if (!Character.isDigit(str.charAt(i)))
				return false;
		}
		return true;
	}



    /**
     * addComponents
     * This function takes a scrollbar, a textfield and add it to the panel
     * of a gridbaglayout
     * Precondition : Scrollbar and Jtextfield is set, and the panel is of a
     *					gridbaglayout.
     * Postcondition : the component is added and the spacing is according to
     *				   the gridbag constraints
     */
	private static void addComponents(JLabel label,Scrollbar tf,
                                      JPanel panel)
    {
        //create a gribbag contraint object
        GridBagConstraints gbc = new GridBagConstraints();
        //set the distance between each element
        gbc.insets = new Insets(2,2,2,2);
        //set the weight and thus the space of that the element takes
        gbc.weighty = 1.0;
        //set the width of the element
        gbc.gridwidth = gbc.RELATIVE;
        //set the weight and thus the space of that the element takes
        gbc.weightx = 0.1;
        //set contraints
        gbc.fill = gbc.NONE;
        //set alignment
        gbc.anchor = gbc.WEST;
        //add lable to panel
        panel.add(label, gbc);
        //set size of the textfield
        gbc.gridwidth = gbc.REMAINDER;
        //set contstraints
        gbc.weightx = 1.0;
        gbc.fill = gbc.HORIZONTAL;
        //set alignment
        gbc.anchor = gbc.WEST;
        //add textfield
        panel.add(tf, gbc);
    }

	//End Helper Functions======================================================


//--------------END--HELPER--METHODS----------------
}
