import java.util.Vector;
import java.io.*;
import java.util.StringTokenizer;
import java.lang.Integer;
import javax.swing.*;


public class DescriptorDataStructure
{
	static private Vector<DescriptorListNode> descriptorPtr;
	private static final String FILENAMES ="FILENAMES";
	private static final String EXT = ".dat";
	static private final int ZERO = 0;
	static private int numResults;
	static boolean initiated = false;

	//*****Constructor****************

	//**********************************************
	//@param null
	//@return null
	//**********************************************
	public DescriptorDataStructure()
	{
		if (initiated == false)
		{
			descriptorPtr = new Vector<DescriptorListNode>();
			//Roger's Mod -x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x
			loadDatabase();
			if (descriptorPtr.size()==0)
			{
				addDescriptorType("Date");
				addDescriptorType("Location");
			}
		}
		initiated = true;
		//-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x
	}

	public Vector<DescriptorListNode> GetVector()
	{
		return descriptorPtr;
	}








	//*****Begin of Methods**********************************************





	//COMMUNICATION REPOSITORY DATA STRUCTURE TO DB


	//**********************************************
	//add descriptor value and update the database
	//@param 3, int, String, String
	//@return boolean
	//**********************************************
	public void addDescriptorValue( int imageID)
	{

		for(int i=0; i < size();i++)
		{

			//update data structure
			Descriptor tempDes = new Descriptor(imageID, "");
			descriptorPtr.get(i).getDescriptors().add(tempDes);
		}

		//update the change in database
		writeFilesToRepositoryDB();
	}




	//**********************************************
	//edit descriptor value and update the database
	//@param 3, int, String, String
	//@return boolean
	//**********************************************
	public void editDescriptorValue( int imageID,
										String dValue,
										String dType)
	{
		for(int i=0; i < size();i++)
		{
			if( descriptorPtr.get(i).getDescriptorType().compareToIgnoreCase(dType) ==0)
			{

				for(int j=0; j < descriptorPtr.get(i).getDescriptors().size(); j++)
				{
					if(descriptorPtr.get(i).getDescriptors().get(j).getID() == imageID)
					{
						//update data structure
						descriptorPtr.get(i).getDescriptors().get(j).setValue(dValue);
					}
				}
			}
		}
		//update the change in database
		writeFilesToRepositoryDB();
	}

	//**********************************************
	//add descriptor type and update the database
	//@param 1, String
	//@return boolean
	//**********************************************
	public boolean addDescriptorType(String dType)
	{
		for(int i=0; i < size();i++)
		{
			if( descriptorPtr.get(i).getDescriptorType().compareToIgnoreCase(dType) == 0)
			{
				//***print GUI descriptor type is already added;
				return false;
			}
		}

		//Otherwise append descriptor Type instance to the data structure.
		DescriptorListNode temp = new DescriptorListNode(dType);
		descriptorPtr.add(temp);

		//Take one of the Data.dat to find # of images

		for(int i=0; i < descriptorPtr.get(ZERO).getDescriptors().size(); i++)
		{
			//Create nodes in Data Structure
			int tempID = descriptorPtr.get(ZERO).getDescriptors().get(i).getID();
			Descriptor tempNode = new Descriptor( tempID, "");
			descriptorPtr.lastElement().getDescriptors().add(tempNode);
		}


		//update the textfile of that descriptor type
		//eg. write ImageID and String "" empty descriptor each line
		writeFilesToRepositoryDB();
		saveFileOfDescriptorTypes();
		return true;
	}


	//**********************************************
	//delete descriptor and update the database
	//@precondition: An image is deleted from Repository DB
	//@param 1 , int
	//**********************************************
	public boolean deleteDescriptor(int ImageID)
	{

		for(int i=0; i < size();i++)
		{
			for(int j=0; j < descriptorPtr.get(i).getDescriptors().size(); j++)
			{
				if(descriptorPtr.get(i).getDescriptors().get(j).getID() == ImageID)
				{
					descriptorPtr.get(i).getDescriptors().remove(j);
				}
			}
		}
		//update. traverse to line j and then delete line for each dat file.
		writeFilesToRepositoryDB();
		return true;
	}







	//COMMUNITCATION DB TO REPOSITORY DATA STRUCTURE




	//**********************************************
	//load imageID and descriptor values to DS
	//@precondition: load ONLY ONCE when Repository is populated
	//**********************************************
	public void loadDatabase()
	{
		try
		{
			int index = 0;
			String line;

			//File file = new File(FILENAMES);
			File TempFile = new File("Repository\\"+FILENAMES+EXT);
			if (TempFile.exists()==false)
			{
				TempFile.createNewFile();
			}
			FileReader fr = new FileReader(new File("Repository\\"+FILENAMES+EXT));
			BufferedReader br = new BufferedReader(fr);
			line = br.readLine();

			//Read each textfile

			while(line!=null)
			{
				descriptorPtr.add( new DescriptorListNode(line));
				String tempLine;

				//Read each line in a textfile
				//eg. 1	"hawaii" , 3 "
				TempFile = new File("Repository\\"+line+EXT);
				if (TempFile.exists()==false)
				{
					TempFile.createNewFile();
				}
				FileReader tempfr = new FileReader(new File("Repository\\"+line+EXT));
				BufferedReader tempBr = new BufferedReader(tempfr);
				tempLine = tempBr.readLine();
				while(tempLine !=null)
				{
					//Load the image ID and descriptor value
					StringTokenizer st = new StringTokenizer(tempLine,"\t");
					Descriptor tempDes;
					int iTemp =Integer.valueOf(st.nextToken());
					if(st.hasMoreTokens())
					{
						tempDes = new Descriptor(iTemp, st.nextToken() );
					}
					else
					{
						tempDes = new Descriptor(iTemp, "");
					}
					descriptorPtr.get(index).addDescriptor(tempDes);


					tempLine = tempBr.readLine();
				}
				tempBr.close();
				index++;
				line = br.readLine();

			}
			br.close();
		}
		catch(Exception e){JOptionPane.showMessageDialog(null,
					"Load Database Error");}
	}

	//**********************************************
	//save filenames of each descriptor type files into a file
	//@precondition: use ONLY ONCE before terminate the DPAS
	//@param: none
	//**********************************************
	public void saveFileOfDescriptorTypes()
	{
		try
		{
			//write FILENAMES.dat.
			PrintWriter pw = new PrintWriter( new FileWriter("Repository/"+ FILENAMES+EXT));

			//write each DescriptorType +".dat" into each line.
			for(int i=0; i < size(); i++)
			{
				pw.println(descriptorPtr.get(i).getDescriptorType() /*+ ".dat"*/);
			}

			//close FILNAMES.dat when done.
			pw.close();
		}
		catch(Exception e){JOptionPane.showMessageDialog(null,
					"SaveFileofDescriptorTypes Error");}
	}

/* USELESS USELESS USELESS USELESS USELESS USELESS USELESS USELESS USELESS USELESS USELESS USELESS USELESS USELESS
	//**********************************************
	//update descriptor type textfiles
	//@precondition: editted descriptor value in the Data Structure, or when added images
	//@param:none
	//**********************************************
	public void writeDescriptorDB(int rowType, int colValue)
	{
		try
		{
			String line;
			String tempFilename = "Repository/" + descriptorPtr.get(rowType).getDescriptorType() +EXT;
			File file = new File( tempFilename );

			RandomAccessFile raf = new RandomAccessFile( file , "rw");

			//
			line = raf.readLine();
			for(int i=0; i < colValue ;i++)
			{
				line = raf.readLine();
			}
			raf.writeBytes(  Integer.toString( descriptorPtr.get(rowType).getDescriptors().get(colValue).getID() )
						+ "\t"
						+ descriptorPtr.get(rowType).getDescriptors().get(colValue).getValue()
						+ "\n");
			raf.close();
		}

		catch(Exception e){}
	}

	//**********************************************
	//Delete the line in DB according to that image deleted
	//@precondtion: use only when image is deleted
	//@param: 1
	//**********************************************
	public void deleteLineDescriptorDB(int lineNum)
	{
		try
		{
		File f = new File("Repository/"+ FILENAMES);
		BufferedReader br = new BufferedReader(new FileReader(f));
		String readFile;

		readFile = br.readLine();
		while(readFile !="")
		{
			File tempFile = new File(readFile);
			BufferedReader tempBr = new BufferedReader( new FileReader(tempFile));
			String read_line = tempBr.readLine();
			int count=0;
			String tempString = new String();
			while(read_line != "")
			{
				//skip the line
				if( count == lineNum)
				{
					read_line=tempBr.readLine();
				}
				//copy each line to tempString
				else
				{
					tempString.concat(read_line + "\n");
				}
			}
			tempBr.close();

			//copies the string to file
			PrintWriter pw = new PrintWriter( new FileWriter(readFile));
			pw.flush();
			pw.write(tempString);
			pw.close();

			//read next filename
			readFile = br.readLine();
		}
		br.close();
		}
		catch(Exception e){e.printStackTrace();}

	}
USELESS USELESS USELESS USELESS USELESS USELESS USELESS USELESS USELESS USELESS USELESS USELESS USELESS */
	public int createNextID()
	{
		if(descriptorPtr.get(ZERO).getDescriptors().size()==0)
		{
			return 0;
		}
		return descriptorPtr.get(ZERO).getDescriptors().lastElement().getID() + 1;
	}




	//SEARCH


	public int[] search(int selNumber)
	{
//		if(selNumber == 1)
//		{
			return searchALL();
//		}
/*		else if(selNumber == 2)
		{
			return searchAND();
		}
		else if(selNumber == 3)
		{
			return searchOR();
		} */
	}



	public int GetPositionFromID(Integer imageID)
	{
		for(int i =0; i<descriptorPtr.get(ZERO).getDescriptors().size();i++)
		{
			if(descriptorPtr.get(ZERO).getDescriptors().get(i).getID() == imageID )
			{
				return i;
			}
		}
		JOptionPane.showMessageDialog(null,
					"Image not found");
		return 0;
	}



	//*******Private Methods***************************






	//**********************************************
	//search all images
	//**********************************************
	private int[] searchALL()
	{
		int ids[] = new int[descriptorPtr.get(ZERO).getDescriptors().size()];


		//use Data Structure to get all IDs into a vector<int>
		int i=0;
		for(; i< descriptorPtr.get(ZERO).getDescriptors().size();i++)
		{
			int tempID = descriptorPtr.get(ZERO).getDescriptors().get(i).getID();
			ids[i] = tempID;
		}

		numResults=i;
		return ids;
	}


	/*	public static void main(String[] args)
	{
		descriptorDataStructure d = new descriptorDataStructure();
		d.loadDatabase();
	}*/





	//Roger's Mod -x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x


	//**********************************************
	//return the size of the Descriptor Type Vector
	//@param:none
	//**********************************************
	public int size()
	{
		return descriptorPtr.size();
	}


	public String GetDescriptorType(int index)
	{
		return descriptorPtr.get(index).getDescriptorType();
	}

	//----------------------------------------------------
	public void writeFilesToRepositoryDB()
	{
		try
		{
			for(int i=0; i < descriptorPtr.size();i++)
			{
				PrintWriter pw = new PrintWriter(
					                     new FileWriter(
											 "Repository/"+descriptorPtr.get(i).getDescriptorType()+EXT));
				for(int j=0; j < descriptorPtr.get(i).getDescriptors().size(); j++)
				{
					pw.println(descriptorPtr.get(i).getDescriptors().get(j).getID()
								+ "\t" + descriptorPtr.get(i).getDescriptors().get(j).getValue()
								);
				}
				pw.close();
			}
		}
		catch(Exception e){System.out.println("error found");}
	}

	//-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x

}