/* 
 * ImagePanel.java
 * 
 * This file contains the class that extends JPanel which shows the result of 
 * search in thumbnails and allow user to click and select the image desired.
 * 
 */ 

//import statements
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import javax.swing.border.*;
import java.util.*;
import javax.imageio.*;
import java.awt.image.*;

/* ImagePanel class
 * 
 * The purpose of this class is to create a custom panel for the album and
 * repository tab so result from search is showned in the panel.
 * 
 * Written by : Roger Yang
 *                                                                          
 * 
 * Version 1.2 29 Nov 2006
 * 
 * Revision    Status       Date            By: 
 * 1.0         Created     19 Nov 2006     Roger Yang       
 * 1.1		   Modified    22 Nov 2006	   Roger Yang                                                              
 * 1.2		   Modified    29 Nov 2006	   Roger Yang                                                       

 */ 
public class ImagePanel extends JPanel
{
	//declare Rfilename object to access file extensions
	RFileName FileExtension = new RFileName();
	//declare imagelist to store thumbnails for showing
	Vector<Integer> ImageList = new Vector<Integer>();
	
	//declare panels for the custom image panel
	JPanel SubPanel = new JPanel();
	JPanel PageControl = new JPanel();
	
	//declare buttons for the custom image panel
	JButton jbPrev = new JButton("Previous 20");
	JButton jbNext = new JButton("Next 20");
	
	//declare and initiate variable to default value
	private int minPicture = 0;
	public int selectPicture = 0;
	public boolean selected = false;
	
	//constant for image per page
	private final int ImagePerPage = 20;

	//declare JLabel array for storing Jlables to be added to panel
	JLabel[] labImage;
	
	/** 
     * Class Constructor
     * This function sets the default values for the gui and variables
     * when the class is first initated.
     */ 
	
	public ImagePanel()
	{
		//set layout for the 
		this.setLayout(new BorderLayout());
		PageControl.setLayout(new GridLayout(1,2));
	
		//add buttons to subpanel
		PageControl.add(jbPrev);
		PageControl.add(jbNext);
		
		
		//Add Action handlers
		ActionHandler e = new ActionHandler();
		jbPrev.addActionListener(e);
		jbNext.addActionListener(e);
	}	
	
	/** 
     * Class Actionhandler
     * This function handles all the actions from the actionlisteners
     */ 
	public class ActionHandler implements ActionListener
	{
		public void actionPerformed(ActionEvent e)
		{
			//if previous button is selected
			if (e.getSource() == jbPrev)
			{
				//test to see if the page is already showing the first page
				if (minPicture-ImagePerPage>=0)
				{
					//set the range of images to show
					minPicture -= ImagePerPage;
					//show the range of images on panel
					showImage(ImageList);
					//reset selected variable since no image is selected
					selected = false;
				}
			}
			//if next button is selected
			else if (e.getSource()==jbNext)
			{
				//test to see if the last page is already showing
				if (minPicture+ImagePerPage<ImageList.size())
				{
					//set the range of images to show
					minPicture += ImagePerPage;
					//show the range of images on panel
					showImage(ImageList);
					//reset the selected variable since no image is selected
					selected = false;
				}
			}
		}
	}

	/** 
     * showImage
     * This function shows the images listed in the vector on the panel and adds
     * actionlisteners on each label.
     * Precondition : vector of images passed in is correct and in right format
     * Postcondition : images are shown on label and each label action is added
     */ 
	public void showImage(Vector<Integer> tempList)
	{
		//check to see if the list is the same as before
		if (ImageList!=tempList)
		{
			//if the lists are different, remove all elements and copy the new list
			ImageList.removeAllElements();
			ImageList.addAll(tempList);
		}
		//set the preferred size of the main panel
		this.setPreferredSize(new Dimension(550,400));
		//remove all images on subpanel
		SubPanel.removeAll();
		
		//decalre and set the size of the new label array
		labImage = new JLabel[ImageList.size()];
		
		//for each image in the current range load the image
		for(int i = minPicture;i < ImageList.size() && i<minPicture+ImagePerPage;i++)
		{	
			//load the image onto the panel
			LoadImage(i);
		}
		
		//if it is the last page and there's not enough image to fill the page
		if (minPicture+ImagePerPage<ImageList.size())
		{
			//set the correct border title for last page
			this.setBorder(new TitledBorder("Showing "+(minPicture+1)+" to "
						+(minPicture+ImagePerPage)+" out of "+ImageList.size()
						+" Search Results"));
		}
		else
		{
			//set the correct border for other pages
			this.setBorder(new TitledBorder("Showing "+(minPicture+1)+" to "
						+ImageList.size()+" out of "+ImageList.size()
						+" Search Results"));
		}
		//update the gui
		this.updateUI();
	}
	
	
	/** 
     * LabelMouseClicked
     * This function catches the mouse event and acts accordingly
     *
     * Precondition : no precondition
     * Postcondition : imageID of image clicked with be stored in static variable
     */ 
    public void LabelMouseClicked(MouseEvent e) 
    {
    	//if the mouse event is from clicking image in the range
		for(int i = minPicture;i < ImageList.size() && i<minPicture+ImagePerPage;i++)
		{
			//set static variable to true so outside classes will know 
			selected = true;
			//set every image in range to true so everybutton can be seen
			labImage[i].setEnabled(true);
			//for the selected image
			if (e.getSource() == labImage[i])
			{
				//store the imageID of the selected image
				selectPicture = ImageList.get(i);
				//set the selected image label to false so shows gray
				labImage[i].setEnabled(false);
			}
		}
	}
	
	/** 
     * LoadImage
     * This function loads the thumbnail for each image in range and put it on 
     * a label then show it on the panel.  This function also addes actionlisteners
     * as the image is added since it is dynamic
     *
     * Precondition : no precondition
     * Postcondition : imageID of image clicked with be stored in static variable
     */ 
	private void LoadImage(int i)
	{
		//declare local variableget the extension for the image
		final String FileExt = FileExtension.getFileExt(ImageList.get(i));	
		//declare and initialize the file variable to the file path of the thumbnail
		final File fImage = new File("Repository/"+ImageList.get(i).toString()+"stmb."+FileExt);
		
		//declare local varialb eimage to store image.
		Image iImage= null;
		//try to load the image from the file
	  	try
	 	{
			iImage = ImageIO.read(fImage);
	  	} 
	  	catch (Exception e) 
	  	{
	  		//output to debug if image read error caught
	  		System.out.println("Image Read Error");
	  	}
			
		//put image into an image icon
		ImageIcon repImage = new ImageIcon(iImage);
		//put image icon into a label
		labImage[i] = new JLabel(repImage);
		//set the label preferred size so each will take up the same dimension
		labImage[i].setPreferredSize(new Dimension(100,100));
		//add label to the panel
		SubPanel.add(labImage[i]);
		//add the mouse listener to each label so it will trigger mouse event
		labImage[i].addMouseListener(new java.awt.event.MouseAdapter() {
        public void mouseClicked(java.awt.event.MouseEvent evt) {
              LabelMouseClicked(evt);
            }
        });
		
        //set the size panel that shows image
        SubPanel.setPreferredSize(new Dimension(550,450));
        
        //add the subpanels to the main panel
        this.add(SubPanel, BorderLayout.CENTER);
        this.add(PageControl, BorderLayout.SOUTH);
	}
	
}