/*
 * Page.java
 * This class create an image object to represent and remember the information of
 * a page in an album. some method to create directory in database.
 */

//import statements
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import javax.swing.plaf.basic.BasicFileChooserUI;
import java.util.*;
import java.beans.PropertyVetoException;


/* Page class
 *
 * The purpose of this class create and store information about a page of an album.
 * each page is an object and will be an empty directory that stored under an album
 *
 * Written by : Zheng Zhang(Simon)
 *
 *
 * Version 1.1 25 Nov 2006
 *
 * Revision    Status       Date            By:
 * 1.0         Created      24 Nov 2006    Zheng Zhang(Simon)
 * 1.1         Modified     25 Nov 2006    Turki Almadi
 */

public class Page{

	//declear variables
	private String AlbumName;
	private String pageNum;
	private int imageId;
	private int textId;


	//constructor that just need album name and page number to make a directory under album file.
	public Page(String AlbumName,int pageNum){

		this.AlbumName = AlbumName;
		this.pageNum = String.valueOf(pageNum);
		imageId = 0;
		textId = 0;
	}

	/*
	 * Class storeInfo //basic
	 * This function make a directory of page with specified page number under
	 * specified album.record the number of text and images in the page.
	 *
	 * precondition: system initalized, object Page created.
	 * postcondition: information stored the the right album and right page.
	 */
	public void storeInfo(){

		new File("Album\\temp\\"+AlbumName+"\\"+"Page"+pageNum).mkdir();
		try{

			PrintWriter fileout = new PrintWriter("Album\\temp\\"+AlbumName+"\\"+"Page"+pageNum+"\\numOfText.txt");
			fileout.println(textId);      //file record how many texts on the page
			fileout.close();

			fileout = new PrintWriter("Album\\temp\\"+AlbumName+"\\"+"Page"+pageNum+"\\numOfImage.txt");
			fileout.println(imageId);     //file record how many images on this page
			fileout.close();

		}catch(IOException e){

		}
	}

    /*
	 * Class updateTextId
	 * This function update the number of texts in the database.
	 *
	 * precondition: system initalized, page is already exists in the database .
	 * postcondition: information textId updated at the right album and right page
	 */
	public static void updateTextId(int currentPageNum, String albumName,int numOfText){

		try{

			PrintWriter fileout = new PrintWriter("Album\\temp\\"+albumName+"\\"+"Page"+currentPageNum+"\\numOfText.txt");
			fileout.println(numOfText);
			fileout.close();

		}catch(IOException e){
		}
	}

	/*
	 * Class getTextId
	 * This function is a getter which read from the file and get the id for next text.
	 *
	 * precondition: system initalized, page is already exists in the database .
	 * postcondition: information textId the the right album and right page for the next text
	 */
	public static int getTextId(int currentPageNum, String albumName){
		try{
		       BufferedReader filein = new BufferedReader(new FileReader("Album\\temp\\"+albumName+"\\"+"Page"+currentPageNum+"\\numOfText.txt"));
		       int id = Integer.parseInt((String)filein.readLine());
				 filein.close();
		       return (id+1); // return one more for the next text
		   }
		catch (IOException e)
		  {

		  }
		return -1;
		}

	/*
	 * Class updateImageId
	 * This function update the number of images in the database.
	 *
	 * precondition: system initalized, page is already exists in the database .
	 * postcondition: information imageId updated at the right album and right page
	 */
	public static void updateImageId(int currentPageNum, String albumName,int numOfImage){
		try{

			PrintWriter fileout = new PrintWriter("Album\\temp\\"+albumName+"\\"+"Page"+currentPageNum+"\\numOfImage.txt");
			fileout.println(numOfImage);
			fileout.close();

		}catch(IOException e){
		}
	}

	/*
	 * Class getImageId
	 * This function is a getter which read from the file and get the id for next image.
	 *
	 * precondition: system initalized, page is already exists in the database .
	 * postcondition: information imageId the the right album and right page for the next image
	 */
	public static int getImageId(int currentPageNum, String albumName){

		try{
		       BufferedReader filein = new BufferedReader(new FileReader("Album\\temp\\"+albumName+"\\"+"Page"+currentPageNum+"\\numOfImage.txt"));
		       int id = Integer.parseInt((String)filein.readLine());
				 filein.close();
		       return (id+1); //return one more for the next image
		   }
		catch (IOException e)
		  {

		  }

		return -1;

	}


	/*
	 * Class getTextvalue
	 * This function is a getter which read from the file and get the value of text and return it.
	 *
	 * precondition: system initalized, the Text is already in the database .
	 * postcondition: information content getted from the the right album and right page
	 */
	public static String getTextValue(int currentPageNum, String albumName, int textId){
		try{
		       BufferedReader filein = new BufferedReader(new FileReader("Album\\temp\\"+albumName+"\\Page"+currentPageNum+"\\"+"Text"+textId+".txt"));
		       filein.readLine();
				 String value = filein.readLine();
				 filein.close();
		       return value;
		   }
		catch (IOException e)
		  {

		  }
		return "Error";
	}

	/*
	 * Class getTextType
	 * This function is a getter which read from the file and get the type of text
	 * ,title or commentary, and return it.
	 *
	 * precondition: system initalized, the Text is already in the database .
	 * postcondition: information type getted from the the right album and right page
	 */
	public static boolean getTextType(int currentPageNum, String albumName, int textId){
		try{
		       BufferedReader filein = new BufferedReader(new FileReader("Album\\temp\\"+albumName+"\\Page"+currentPageNum+"\\"+"Text"+textId+".txt"));
				 String value = filein.readLine();
				 filein.close();
				 if (value.equalsIgnoreCase("true"))
				 {
		             return true;
				 }else{
				 return false;
				 }
		   }
		catch (IOException e)
		  {

		  }

		return false;
	}

	/*
	 * Class getTextpos
	 * This function is a getter which read from the file and get the position of text and return it.
	 *
	 * precondition: system initalized, the Text is already in the database .
	 * postcondition: information position getted from the the right album and right page
	 */
	public static Position getTextPos(int currentPageNum, String albumName, int textId){
		try{
		       BufferedReader filein = new BufferedReader(new FileReader("Album\\temp\\"+albumName+"\\Page"+currentPageNum+"\\"+"Text"+textId+".txt"));
		       String st1 = filein.readLine();
				 st1 = filein.readLine();
			    st1 = filein.readLine();
				 int x = Integer.parseInt(st1);
				 st1 = filein.readLine();
				 int y = Integer.parseInt(st1);
				 Position pos = new Position(x,y);
	          filein.close();

			    return pos;
		   }
		catch (IOException e)
		  {

		  }
		Position err = new Position(0,0);
		return err ;
	}

	/*
	 * Class getImageDir
	 * This function is a getter which read from the file and get the directory
	 * of image and return it.
	 *
	 * precondition: system initalized, image is already exists in the database.
	 * postcondition: information directory getted from the the right album and right page
	 */
	public static String getImageDir(int currentPageNum, String albumName, int imageId){
		try{
		       BufferedReader filein = new BufferedReader(new FileReader("Album\\temp\\"+albumName+"\\Page"+currentPageNum+"\\"+"Image"+imageId+".txt"));
				 String value = filein.readLine();
				 filein.close();
		       return value;
		   }
		catch (IOException e)
		  {
		  }

		return "Error";
	}

    /*
	 * Class getImagePos
	 * This function is a getter which read from the file and get the position of image and return it.
	 *
	 * precondition: system initalized, the image is already in the database
	 * postcondition: information position getted from the the right album and right page
	 */
	public static Position getImagePos(int currentPageNum, String albumName, int imageId){
		try{
		       BufferedReader filein = new BufferedReader(new FileReader("Album\\temp\\"+albumName+"\\Page"+currentPageNum+"\\"+"Image"+imageId+".txt"));
		       String st1 = filein.readLine();
			    st1 = filein.readLine();
				 int x = Integer.parseInt(st1);
				 st1 = filein.readLine();
				 int y = Integer.parseInt(st1);
				 Position pos = new Position(x,y);
	          filein.close();

			    return pos;
		   }
		catch (IOException e)
		  {
		  }
		Position err = new Position(0,0);
		return err ;
	}


    /*
	 * Class getImageSize
	 * This function is a getter which read from the file and get the size of
	 * image and return it for editting.
	 *
	 * precondition: system initalized, the image is already in the database
	 * postcondition: information size getted from the the right album and right page
	 */
	public static double[] getImageSize(int currentPageNum, String albumName, int imageId){
		try{

				 double[] size = new double[2];
				 BufferedReader filein = new BufferedReader(new FileReader("Album\\temp\\"+albumName+"\\Page"+currentPageNum+"\\"+"Image"+imageId+".txt"));
		       String st1 = filein.readLine();
			    st1 = filein.readLine();
				 st1 = filein.readLine();
				 st1 = filein.readLine();
				 size[0] = Double.parseDouble(st1);
				 st1 = filein.readLine();
				 size[1] = Double.parseDouble(st1);
	          filein.close();

			    return size;
		   }
		catch (IOException e)
		  {
		  }
		double[] err = new double[2];
		err[0] = 1;
		err[1] = 1;
		return err ;
	}


    /*
	 * Class getImageRotation
	 * This function is a getter which read from the file and get the rotation
	 * degree of image and return it for editting.
	 *
	 * precondition: system initalized, the image is already in the database
	 * postcondition: information rotation degree getted from the the right album
	 *                and right page  and returns out
	 */
	public static double getImageRotation(int currentPageNum, String albumName, int imageId){
		try{
				 BufferedReader filein = new BufferedReader(new FileReader("Album\\temp\\"+albumName+"\\Page"+currentPageNum+"\\"+"Image"+imageId+".txt"));
		       String st1 = filein.readLine();
			    st1 = filein.readLine();
				 st1 = filein.readLine();
				 st1 = filein.readLine();
				 st1 = filein.readLine();
				 st1 = filein.readLine();
				 double rotation = Double.parseDouble(st1);
	          filein.close();

			    return rotation;
		   }
		catch (IOException e)
		  {
		  }
		return 0.0 ;
	}

    /*
	 * Class getImageCrop
	 * This function is a getter which read from the file and get the crop position
	 * of image and return it for editing.
	 *
	 * precondition: system initalized, the image is already in the database
	 * postcondition: information crop getted and returned a Position function
	 */
	public static Position[] getImageCrop(int currentPageNum, String albumName, int imageId){
		try{
		       String st1;
				 Position[] crop = new Position[2];
				 BufferedReader filein = new BufferedReader(new FileReader("Album\\temp\\"+albumName+"\\Page"+currentPageNum+"\\"+"Image"+imageId+".txt"));
				 st1 = filein.readLine();
			    st1 = filein.readLine();
				 st1 = filein.readLine();
				 st1 = filein.readLine();
				 st1 = filein.readLine();
				 st1 = filein.readLine();
				 st1 = filein.readLine();
				 System.out.println(st1);
				 int x1 = Integer.parseInt(st1);          //two position make a square to crop
				 st1 = filein.readLine();
				 int x2 = Integer.parseInt(st1);
				 crop[0] = new Position(x1,x2);
				 st1 = filein.readLine();
				 int y1 = Integer.parseInt(st1);
				 st1 = filein.readLine();
				 int y2 = Integer.parseInt(st1);
				 crop[1] = new Position(y1,y2);

	          filein.close();

			    return crop;
		   }
		catch (IOException e)
		  {
		  }
		Position[] err = new Position[2];
		err[0] = new Position(0,0);
		err[1] = new Position(0,0);
		return err ;
	}

}


