/*
 * Text.java
 * This class create a text object to represent and remember the information of
 * text on the page of an album. some method to store information in database.
 */

//import statements.
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import javax.swing.plaf.basic.BasicFileChooserUI;
import java.util.*;
import java.beans.PropertyVetoException;

/* Text class
 * 
 * The purpose of this class create and store information about a text on a page
 * of an album. each text is an object and will be a file that stored under a
 * page of an album
 *
 * Written by : Zheng Zhang(Simon)
 *                                                                          
 * 
 * Version 1.1 27 Nov 2006
 * 
 * Revision    Status       Date            By: 
 * 1.0         Created      24 Nov 2006    Zheng Zhang(Simon)
 * 1.1         Modified     27 Nov 2006    Turki Almadi
 */    
 
public class Text{
	
	//variable clearfication
	private boolean isTitle;
	private String content;
	private Position p;
	private int size;
	private String textId;
	private String albumName;
	private int pageNum;
	
	//constructor ....
	public Text(boolean isTitle, String content, Position p, int textId, String albumName, int pageNum){
		
		this.isTitle = isTitle;  // if text is a commentary or a title
		this.content = content;
		this.p = p;
		this.textId = String.valueOf(textId);
		this.albumName = albumName;
		this.pageNum = pageNum;
		
		if(isTitle){   //can be used as font size
			size = 18; //title larger
		}else{ 
			size = 12; // comment smaller
		}
	}
	
	/*
	 * Class storeInfo //non - static
	 * This function get the information stored to a album to the temp file which
	 * can be modified so that when album not saved it is not changed.
	 *
	 * precondition: system initalized, object Text created.
	 * postcondition: information stored the the right album and right page
	 */
	
	public void storeInfo(){
		
		try{ 	
			PrintWriter fileout = new PrintWriter("Album\\temp\\"+albumName+"\\Page"+pageNum+"\\"+"Text"+textId+".txt");  // Write data to textId.txt
			
            fileout.println(isTitle);                              // writing....
            fileout.println(content);
            fileout.println(p.getX());
			fileout.println(p.getY());
            
			fileout.close();	                                   // must close.
		
	    }catch(IOException e){
	    	
	    	System.out.println(e);
	    }
	}
	
	/*
	 * Class storeInfo //static-content
	 * This function is a more flexiabled version to store and update text file 
	 * in the database. more on the content part.
	 *
	 * precondition: system initalized, the Text is already in the database .
	 * postcondition: information content updated the the right album and right page
	 */
	
	public static void storeInfo(String albumName2, int currentPageNum, int textID, String newContent){
		
		try{ 	
			BufferedReader filein = new BufferedReader(new FileReader("Album\\temp\\"+albumName2+"\\Page"+currentPageNum+"\\"+"Text"+textID+".txt"));
			 //read the file stored in database that we want to update
			  
			  String firstLine = filein.readLine();
			  filein.readLine();                          // Read the line of content
			  String thirdLine = filein.readLine();
			  String fourthLine = filein.readLine();        
			
         filein.close();                                  // dump it
			
		 PrintWriter fileout = new PrintWriter("Album\\temp\\"+albumName2+"\\Page"+currentPageNum+"\\"+"Text"+textID+".txt");   
		     // update it.
			fileout.println(firstLine);
			fileout.println(newContent);                  // update it to new content 
			fileout.println(thirdLine);
			fileout.println(fourthLine);
		
		 fileout.close();	                                   
		
	    }catch(IOException e){
	    	
	    	System.out.println(e);
	    }
	}

	/*
	 * Class storeInfo //static-position
	 * This function is a more flexiabled version to store and update text file 
	 * in the database. more on the position part.
	 *
	 * precondition: system initalized, the Text is already in the database .
	 * postcondition: information position updated the the right album and right page
	 */

	public static void storeInfo(String albumName2, int currentPageNum, int textID, Position pos){
		
		try{ 	
			BufferedReader filein = new BufferedReader(new FileReader("Album\\temp\\"+albumName2+"\\Page"+currentPageNum+"\\"+"Text"+textID+".txt"));
			   //read the file stored in database that we want to update
			  String firstLine = filein.readLine();
			  String secondLine = filein.readLine();
			  filein.readLine();        // Read the line of position
			
         filein.close();               //dump it
			 
		 PrintWriter fileout = new PrintWriter("Album\\temp\\"+albumName2+"\\Page"+currentPageNum+"\\"+"Text"+textID+".txt");   
		    // update it.
			fileout.println(firstLine);
			fileout.println(secondLine);
			fileout.println(pos.getX());    // write new infor to it
			fileout.println(pos.getY());
		
		 fileout.close();	                                   
		
	    }catch(IOException e){
	    	
	    	System.out.println(e);
	    }
	}


}