import java.awt.*;
import java.awt.geom.*;
import java.awt.image.*;
import java.io.*;
import java.net.*;
import javax.imageio.*;
import javax.swing.*;

public class Tilt {

  public static BufferedImage tilt(BufferedImage src, double angle) {
        int w = src.getWidth(), h = src.getHeight();
        angle = (Math.PI/180)*angle;
        int newW = (int)(Math.round(h * Math.abs(Math.sin(angle))+w * Math.abs(Math.cos(angle))));
        int newH = (int)(Math.round(h * Math.abs(Math.cos(angle))+w * Math.abs(Math.sin(angle))));
        AffineTransform at = AffineTransform.getTranslateInstance((newW-w)/2,(newH-h)/2);
        at.rotate(angle, w/2, h/2);
        AffineTransformOp op = new AffineTransformOp(at, AffineTransformOp.TYPE_BILINEAR);
        BufferedImage dst = op.filter(src, null);
        return dst;
    }
}
