//Particle effects Version 1.2, June 3, 2003.
//Instructor: Zhenyu George Li

bmap p_smoke = <smoke.pcx>;
bmap p_fire = <fire.pcx>;
bmap p_ball = <spell.pcx>;
bmap p_body = <fire.pcx>;
//-------------------------------Ball Action --------------------------------

function body_property()
{
  my.alpha -= 0.05 * time;
  if(my.alpha <= 0) { my.lifespan = 0; }
}


function body_effect()
{
   my.vel_x = random(my.skill1)-my.skill1/2;
   my.vel_y = random(my.skill1)-my.skill1/2;
   my.vel_z = random(my.skill1);
   my.move = on;
   my.size = 10;
   my.bmap = p_body;
   my.bright = on;
   my.flare = on;
   my.alpha = 50;
   my.lifespan = random(100);
   my.red = 100;
   my.green = 80;
   my.blue = 100;
   my.function = body_property;
} 

action body
{
	if(my.skill1 <= 0) { my.skill1 = 20; }
   if(my.skill2 <= 0) { my.skill2 = 20; }
   my.invisible = on;
   while(1)
   {
   	my.red = random(255);
      my.green = random(255);
      my.blue = random(255); 
      temp.x = my.x + random(800) - 400;
      temp.y = my.y + random(800) - 400;
      temp.z = my.z;
      effect(body_effect, my.skill2 * time, temp, temp);
      wait(1);
   }
}

//-------------------------------Ball Action --------------------------------

function ball_property()
{
  my.alpha -= 0.1 * time;
  if(my.alpha <= 0) { my.lifespan = 0; }
}


function ball_effect()
{
   my.vel_x = random(my.skill1)-my.skill1/2;
   my.vel_y = random(my.skill1)-my.skill1/2;
   my.vel_z = random(my.skill1)-my.skill1/2;
   my.move = on;
   my.size = 10;
   my.bmap = p_ball;
   my.bright = on;
   my.flare = on;
   my.alpha = 15;
   my.lifespan = random(64);
   my.red = 200;
   my.green = 200;
   my.blue = 5;
   my.function = ball_property;
} 

action ball
{
   if(my.skill1 <= 0) { my.skill1 = 10; }
   if(my.skill2 <= 0) { my.skill2 = 10; }
   my.invisible = on;
   while(1)
   {
   	my.red = random(255);
      my.green = random(255);
      my.blue = random(255); 
      temp.x = my.x + random(4) - 2;
      temp.y = my.y + random(4) - 2;
      temp.z = my.z + random(4) - 2;
       effect(ball_effect, my.skill2 * time, temp, temp);
      wait(1);
   }
}



//-------------------------------Smoke Action --------------------------------

function smoke_property()
{
  my.alpha -= 0.1 * time;
  if(my.alpha <= 0) { my.lifespan = 0; }
}


function smoke_effect()
{
   my.vel_x = 0;
   my.vel_y = 0;
   my.vel_z =random(2);
   my.move = on;
   my.size = 15;
   my.bmap = p_smoke;
   my.flare = on;
   my.alpha = 10;
   my.lifespan = 64;
   my.red = 128;
   my.green = 128;
   my.blue = 128;
   my.function = smoke_property;
} 

action smoke
{
   if(my.skill1 <= 0) { my.skill1 = 32; }
   if(my.skill2 <= 0) { my.skill2 = 10; }
   my.invisible = on;
   while(1)
   {
      temp.x = my.x + random(my.skill1) - my.skill1 / 2;
      temp.y = my.y + random(my.skill1) - my.skill1 / 2;
      temp.z = my.z;
      effect(smoke_effect, my.skill2 * time, temp, temp);
      wait(1);
   }
}

//-------------------------------Fire Action --------------------------------

var FireSquare = 30;

function fire_property()
{
    my.alpha -= 1 * time;
    if(my.alpha <= 0) { my.lifespan = 0; }
    my.red -= 5 * time;
    my.green - = 15 * time;
}

function fire_effect()
{
    my.x += random(FireSquare * (sin(total_ticks * 200) * cos(total_ticks * 50)));
    my.y += random(FireSquare * (sin(total_ticks * 200) * sin(total_ticks * 50)));
    my.size = 15;
    my.vel_x = 0;
    my.vel_y = 0;
    my.vel_z = 2 * random(2);
    my.move = on;
    my.bmap = p_fire;
    my.flare = on;
    my.bright = on;
    my.alpha = 25;
    my.lifespan = 16;
    my.red = 255;
    my.green = 255;
    my.blue = 0;
    my.transparent = on;
    my.function = fire_property;
}

action fire
{
    if(my.skill1 <= 0) { my.skill1 = 20; }
    if(my.skill2 > 0) { FireSquare = my.skill2; }
    my.lightrange = FireSquare + 50;
    while(1)
    {
        my.red = 100 + random(100);
        my.green = 30 + random(100);
        my.blue = 0; 
        vec_set(temp.x, my.x);
        effect(fire_effect, my.skill1 * time, temp, temp);
        wait(1);
    }
}

//------------------------------- Neon --------------------------------

action Neon
{
   if(my.skill1 <= 0) { my.skill1 = 200; }
   if(my.skill2 <= 0) { my.skill2 = 1; }
   my.lightrange = my.skill1;
   while(1)
   {
      my.red = random(255);
      my.green = random(255);
      my.blue = random(255);  
      waitt(my.skill2 * 16);
   }
}

//------------------------------- Shock --------------------------------
var Sv_Angle[3];

function Shock(Duration)
{
   vec_set(Sv_Angle.pan, camera.pan);
   Duration *= 16;
   randomize();
   while(Duration > 0)   
   {
      camera.pan = Sv_Angle.pan + 1 - random(2);
      camera.tilt = Sv_Angle.tilt + 1 - random(2);
      camera.roll = Sv_Angle.roll + 1 - random(2);
      Duration -= 1;
      waitt(1);
   }   
   vec_set(camera.pan, Sv_Angle.pan);
}

//------------------------------- Weather ------------------------------
define FINE 0;
define RAIN 1;
define SNOW 2;

var WeatherType = FINE;
var Weather_Intensity = 100;

entity* Generator;

bmap RainBmp = <rain.pcx>;
bmap SnowBmp = <snow.pcx>;
sound RainSound = <rain.wav>;
sound ThunderSound = <thunder.wav>;
sound LightningSound = <thunder2.wav>;

var WeatherSndH;
var VecFrom[3];
var VecTo[3];

function ChangeWeather(WeatherID)
{
   WeatherType = WeatherID;
   if(snd_playing(WeathersndH) == 1) { snd_stop(WeatherSndH); }
   if(WeatherType == RAIN) 
   { 
      if(Weather_Intensity < 100) 
      { 
      	WeatherSndH = snd_loop(RainSound, Weather_Intensity, 0); 
      }
      else 
      { 
      	WeatherSndH = snd_loop(RainSound, 100, 0); 
      }
   }
}

function Rain_Property()
{
  if(my.z <= my.skill_z) { my.lifespan = 0; }
}

function Rain_Effect()
{
    my.bmap = RainBmp;
    my.lifespan = 50;
    my.x = camera.x + random(2000) - 1000;
    my.y = camera.y + random(2000) - 1000;
    my.vel_x = 0;
    my.vel_y = 0;
    my.vel_z = -20;
    my.z = camera.z + 100;
    my.move = on;
    my.flare = on;
    my.size = 8;
    my.alpha = 25;
    
    vec_set(VecFrom.x, my.x);
    VecFrom.z = camera.z;
    vec_set(VecTo.x, VecFrom.x);
    VecTo.z += 5000;
    trace_mode = ignore_sprites + ignore_passable;
    var TraceDist = 0;
    TraceDist = trace(VecFrom.x, VecTo.x);
    if(TraceDist > 0) { my.skill_z = Camera.z + TraceDist;} 
    else { my.skill_z = Camera.z - 100;} 

    my.function = rain_property;
}

function Snow_Property()
{
		if(my.z <= camera.z - 100) 
  		{ 
	  		my.lifespan = 0;
  		}
  		vec_set(temp.x, my.x);
  		temp.z += 1000;
  		trace_mode = ignore_sprites + ignore_passable;
  		if(trace(my.x, temp.x) != 0) 
  		{ 
  			my.lifespan = 0; 
  		}
}

function Snow_Effect()
{
    my.bmap = SnowBmp;
    my.lifespan = 40;
    my.x = camera.x + random(2000) - 1000;
    my.y = camera.y + random(2000) - 1000;
    my.vel_x = random(4) - 2;
    my.vel_y = random(8) - 4;
    my.vel_z = -3;
    my.z = camera.z + 100;
    my.move = on;
    my.flare = on;
    my.size = 2;
    my.alpha = 40;
    my.function = Snow_property;
}

string LightningFile = "lightning+4.pcx";

function LightningAction()
{
   var handle = 0;
   my.facing = off;
   my.oriented = on;
   my.pan = camera.pan;
   my.roll = 35;
   my.scale_x = 0.2;
   my.scale_y = 0.1;
   my.red = 200;
   my.green = 200;    
   my.blue = 200;
   my.flare = on;
   my.skill1 = 0;
   while(my.skill1 <= 100)
   {
      my.skill1 += 25 * time;
      ent_frame(LightningFile, my.skill1);
      my.lightrange = 800 + random(400);
      wait(1);
   }
   my.invisible = on;
   my.lightrange = 0;
   waitt(8);
   handle = ent_playsound(my, LightningSound, 900);
   while(snd_playing(handle) == 1) { wait(1); }
   snd_play(ThunderSound, 60, 0);
   ent_remove(my);
}

function WeatherMonitor()
{
    while(1)
    {
        if(WeatherType == RAIN)
        { 
				vec_set(temp.x, camera.x);
           	effect(Rain_Effect, Weather_Intensity * (random(1) + 0.5), temp, temp);
           if(random(1) >= 0.9998) 
           { 
        	   if(Weather_Intensity >= 150)           //Lightning
	           {
        	       temp.x = camera.x + 300 * cos(camera.pan); 
	               temp.y = camera.y + 300 * sin(camera.pan);
        	       temp.x -= (random(640) - 320) * sin(camera.pan);
	               temp.y += (random(640) - 320) * cos(camera.pan);
        	       temp.z = camera.z + 100;
	               ent_create(LightningFile, temp, LightningAction);
	           }
                   else
		   {
		       snd_play(ThunderSound, 70, 0);
     		   }
	   }
        } 
        if(WeatherType == SNOW)
        { 
           vec_set(temp.x, camera.x);
           temp.z += 100;
           effect(Snow_Effect, Weather_Intensity * (random(20) + 0.5), temp, temp);
        }
        wait(1);
    }    
    
}



